/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.scoop;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class SCoopTaskBlock
extends TranslatorBlock {
    private static int taskId = 0;

    public SCoopTaskBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock;
        StringBuffer setupCodeBuffer = new StringBuffer();
        for (translatorBlock = this.getTranslatorBlockAtSocket(0); translatorBlock != null; translatorBlock = translatorBlock.nextTranslatorBlock()) {
            setupCodeBuffer.append(translatorBlock.toCode());
        }
        StringBuffer loopCodeBuffer = new StringBuffer();
        for (translatorBlock = this.getTranslatorBlockAtSocket(1); translatorBlock != null; translatorBlock = translatorBlock.nextTranslatorBlock()) {
            loopCodeBuffer.append(translatorBlock.toCode());
        }
        return this.generateScoopTask(setupCodeBuffer.toString(), loopCodeBuffer.toString());
    }

    String generateScoopTask(String setupCommand, String loopCommand) {
        this.translator.addHeaderFile("SCoop.h");
        this.translator.addSetupCommand("mySCoop.start();");
        String taskName = SCoopTaskBlock.createScoopTaskName();
        String ret = "defineTask(" + taskName + ")\n" + "void " + taskName + "::setup()\n" + "{\n";
        ret = ret + setupCommand;
        ret = ret + "}\n\n" + "void " + taskName + "::loop()\n" + "{\n";
        ret = ret + loopCommand;
        ret = ret + "}\n\n";
        return ret;
    }

    public static String createScoopTaskName() {
        return "scoopTask" + ++taskId;
    }
}

