/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public class ContextMenu
extends PopupMenu
implements ActionListener {
    private static final long serialVersionUID = 328149080421L;
    private static ContextMenu rndBlockMenu = new ContextMenu();
    private static ContextMenu addCommentMenu = new ContextMenu();
    private static MenuItem addCommentItem;
    private static final String ADD_COMMENT_BLOCK = "ADDCOMMENT";
    private static boolean addCommentMenuInit;
    private static ContextMenu removeCommentMenu;
    private static MenuItem removeCommentItem;
    private static final String REMOVE_COMMENT_BLOCK = "REMOVECOMMENT";
    private static boolean removeCommentMenuInit;
    private static final String CLONE_BLOCK = "CLONE";
    private static MenuItem cloneItem1;
    private static MenuItem cloneItem2;
    private static ContextMenu canvasMenu;
    private static MenuItem arrangeAllBlocks;
    private static final String ARRANGE_ALL_BLOCKS = "ARRANGE_ALL_BLOCKS";
    private static boolean canvasMenuInit;
    private static Object activeComponent;

    static {
        addCommentMenuInit = false;
        removeCommentMenu = new ContextMenu();
        removeCommentMenuInit = false;
        cloneItem1 = null;
        cloneItem2 = null;
        canvasMenu = new ContextMenu();
        canvasMenuInit = false;
        activeComponent = null;
    }

    private ContextMenu() {
    }

    private static void initAddCommentMenu() {
        ResourceBundle uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        addCommentItem = new MenuItem(uiMessageBundle.getString("ardublock.ui.add_comment"));
        addCommentItem.setActionCommand(ADD_COMMENT_BLOCK);
        addCommentItem.addActionListener(rndBlockMenu);
        addCommentMenu.add(addCommentItem);
        cloneItem1 = new MenuItem(uiMessageBundle.getString("ardublock.ui.clone"));
        cloneItem1.setActionCommand(CLONE_BLOCK);
        cloneItem1.addActionListener(rndBlockMenu);
        addCommentMenu.add(cloneItem1);
        addCommentMenuInit = true;
    }

    private static void initRemoveCommentMenu() {
        ResourceBundle uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        removeCommentItem = new MenuItem(uiMessageBundle.getString("ardublock.ui.delete_comment"));
        removeCommentItem.setActionCommand(REMOVE_COMMENT_BLOCK);
        removeCommentItem.addActionListener(rndBlockMenu);
        removeCommentMenu.add(removeCommentItem);
        cloneItem2 = new MenuItem(uiMessageBundle.getString("ardublock.ui.clone"));
        cloneItem2.setActionCommand(CLONE_BLOCK);
        cloneItem2.addActionListener(rndBlockMenu);
        removeCommentMenu.add(cloneItem2);
        removeCommentMenuInit = true;
    }

    private static void initCanvasMenu() {
        ResourceBundle uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        arrangeAllBlocks = new MenuItem(uiMessageBundle.getString("ardublock.ui.organize_blocks"));
        arrangeAllBlocks.setActionCommand(ARRANGE_ALL_BLOCKS);
        arrangeAllBlocks.addActionListener(canvasMenu);
        canvasMenu.add(arrangeAllBlocks);
        canvasMenuInit = true;
    }

    public static PopupMenu getContextMenuFor(Object o) {
        if (o instanceof RenderableBlock) {
            if (((RenderableBlock)o).hasComment()) {
                if (!removeCommentMenuInit) {
                    ContextMenu.initRemoveCommentMenu();
                }
                activeComponent = o;
                return removeCommentMenu;
            }
            if (!addCommentMenuInit) {
                ContextMenu.initAddCommentMenu();
            }
            activeComponent = o;
            return addCommentMenu;
        }
        if (o instanceof BlockCanvas) {
            if (!canvasMenuInit) {
                ContextMenu.initCanvasMenu();
            }
            activeComponent = o;
            return canvasMenu;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand() == ARRANGE_ALL_BLOCKS) {
            if (activeComponent != null && activeComponent instanceof BlockCanvas) {
                ((BlockCanvas)activeComponent).arrangeAllBlocks();
            }
        } else if (a.getActionCommand() == ADD_COMMENT_BLOCK) {
            if (activeComponent != null && activeComponent instanceof RenderableBlock) {
                ((RenderableBlock)activeComponent).addComment();
            }
        } else if (a.getActionCommand() == REMOVE_COMMENT_BLOCK) {
            if (activeComponent != null && activeComponent instanceof RenderableBlock) {
                ((RenderableBlock)activeComponent).removeComment();
            }
        } else if (a.getActionCommand() == CLONE_BLOCK && activeComponent != null && activeComponent instanceof RenderableBlock) {
            ((RenderableBlock)activeComponent).cloneMe();
        }
    }
}

