/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.xinchejian;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class XinchejianMotorBackwardBlock
extends TranslatorBlock {
    public XinchejianMotorBackwardBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addDefinitionCommand("#define XINCHEJIAN_MOTORSHIELD_M1_FORWARD\t5\n#define XINCHEJIAN_MOTORSHIELD_M1_BACKWARD\t6\n#define XINCHEJIAN_MOTORSHIELD_M2_FORWARD\t9\n#define XINCHEJIAN_MOTORSHIELD_M2_BACKWARD\t10\n\nvoid __ardublock_xinchejian_ms(int motorNumber, boolean forward, int speed)\n{\nif (speed > 255)\n{\nspeed = 255;\n}\nif (speed < 0)\n{\nspeed = 0;\n}\nif (motorNumber == 1)\n{\nif (forward)\n{\ndigitalWrite(XINCHEJIAN_MOTORSHIELD_M1_BACKWARD, LOW);\nanalogWrite(XINCHEJIAN_MOTORSHIELD_M1_FORWARD, speed);\n}\nelse\n{\ndigitalWrite(XINCHEJIAN_MOTORSHIELD_M1_FORWARD, LOW);\nanalogWrite(XINCHEJIAN_MOTORSHIELD_M1_BACKWARD, speed);\n}\n}\nelse\n{\nif (motorNumber == 2)\n{\nif (forward)\n{\ndigitalWrite(XINCHEJIAN_MOTORSHIELD_M2_BACKWARD, LOW);\nanalogWrite(XINCHEJIAN_MOTORSHIELD_M2_FORWARD, speed);\n}\nelse\n{\ndigitalWrite(XINCHEJIAN_MOTORSHIELD_M2_FORWARD, LOW);\nanalogWrite(XINCHEJIAN_MOTORSHIELD_M2_BACKWARD, speed);\n}\n}\n}\n}");
        String ret = "__ardublock_xinchejian_ms( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        ret = String.valueOf(ret) + tb.toCode();
        ret = String.valueOf(ret) + " , false, ";
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        ret = String.valueOf(ret) + tb.toCode();
        ret = String.valueOf(ret) + " );\n";
        return ret;
    }
}

