/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.debug.TargetPackage;
import processing.app.tools.ExternalProcessExecutor;
import processing.app.windows.ListComPortsParser;
import processing.app.windows.Registry;
import processing.core.PApplet;
import processing.core.PConstants;

public class Platform
extends processing.app.Platform {
    static final String openCommand = System.getProperty("user.dir").replace('/', '\\') + "\\arduino.exe \"%1\"";
    static final String DOC = "Arduino.Document";
    static WinLibC clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);

    @Override
    public void init(Base base) {
        super.init(base);
        this.checkAssociations();
        this.checkQuickTime();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String knownCommand = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open\\command", "");
            if (knownCommand == null) {
                if (Preferences.getBoolean("platform.auto_file_type_associations")) {
                    this.setAssociations();
                }
            } else if (!knownCommand.equals(openCommand) && Preferences.getBoolean("platform.auto_file_type_associations")) {
                this.setAssociations();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        if (!(Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", ".ino") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, ".ino", "", DOC) && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", DOC) && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "", "Arduino Source Code") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "shell") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell", "open") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open", "command") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open\\command", "", openCommand))) {
            Preferences.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkQuickTime() {
        try {
            File qtjavaZip;
            String qtsystemPath = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, "Software\\Apple Computer, Inc.\\QuickTime", "QTSysDir");
            if (qtsystemPath != null && (qtjavaZip = new File(qtsystemPath, "QTJava.zip")).exists()) {
                String qtjavaZipPath = qtjavaZip.getAbsolutePath();
                String cp = System.getProperty("java.class.path");
                System.setProperty("java.class.path", cp + File.pathSeparator + qtjavaZipPath);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join((String[])(legit = PApplet.subset((String[])legit, (int)0, (int)legitCount)), (String)File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        String keyPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String appDataPath = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, keyPath, "AppData");
        File dataFolder = new File(appDataPath, "Arduino15");
        return dataFolder;
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String keyPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String personalPath = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, keyPath, "Personal");
        return new File(personalPath, "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        if (url.startsWith("http://")) {
            Runtime.getRuntime().exec("cmd /c start " + url);
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        String folder = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + folder + "\"");
    }

    @Override
    public void setenv(String variable, String value) {
        clib._putenv(variable + "=" + value);
    }

    @Override
    public String getenv(String variable) {
        return System.getenv(variable);
    }

    @Override
    public int unsetenv(String variable) {
        return clib._putenv(variable + "=");
    }

    @Override
    public String getName() {
        return PConstants.platformNames[1];
    }

    @Override
    public String resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        if (devicesListOutput == null) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
        try {
            String vidPid = new ListComPortsParser().extractVIDAndPID(devicesListOutput, serial);
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExternalProcessExecutor executor = new ExternalProcessExecutor(baos);
        try {
            String listComPorts = new File(System.getProperty("user.dir"), "hardware/tools/listComPorts.exe").getCanonicalPath();
            CommandLine toDevicePath = CommandLine.parse((String)listComPorts);
            executor.execute(toDevicePath);
            return new String(baos.toByteArray());
        }
        catch (Throwable e) {
            return super.preListAllCandidateDevices();
        }
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

