/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.text.Segment;
import processing.app.Editor;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;
import processing.core.PApplet;

public class DiscourseFormat {
    private Editor editor;
    private JEditTextArea textarea;
    private boolean html;

    public DiscourseFormat(Editor editor, boolean html) {
        this.editor = editor;
        this.textarea = editor.getTextArea();
        this.html = html;
    }

    public void show() {
        StringBuilder cf = new StringBuilder(this.html ? "<pre>\n" : "[code]\n");
        int selStart = this.textarea.getSelectionStart();
        int selStop = this.textarea.getSelectionStop();
        int startLine = this.textarea.getSelectionStartLine();
        int stopLine = this.textarea.getSelectionStopLine();
        if (selStart == selStop) {
            startLine = 0;
            stopLine = this.textarea.getLineCount() - 1;
        } else if (this.textarea.getLineStartOffset(stopLine) == selStop) {
            --stopLine;
        }
        for (int i = startLine; i <= stopLine; ++i) {
            this.appendFormattedLine(cf, i);
        }
        cf.append(this.html ? "\n</pre>" : "\n[/code]");
        StringSelection formatted = new StringSelection(cf.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(formatted, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
        Clipboard unixclipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (unixclipboard != null) {
            unixclipboard.setContents(formatted, null);
        }
        this.editor.statusNotice("Code formatted for " + (this.html ? "HTML" : "the Arduino forum") + " has been copied to the clipboard.");
    }

    private void appendToHTML(char c, StringBuilder buffer) {
        if (!this.html) {
            buffer.append(c);
        } else if (c == '<') {
            buffer.append("&lt;");
        } else if (c == '>') {
            buffer.append("&gt;");
        } else if (c == '&') {
            buffer.append("&amp;");
        } else if (c > '\u007f') {
            buffer.append("&#" + c + ";");
        } else {
            buffer.append(c);
        }
    }

    public void appendFormattedLine(StringBuilder cf, int line) {
        Segment segment = new Segment();
        TextAreaPainter painter = this.textarea.getPainter();
        TokenMarker tokenMarker = this.textarea.getTokenMarker();
        this.textarea.getLineText(line, segment);
        char[] segmentArray = segment.array;
        int limit = segment.getEndIndex();
        int segmentOffset = segment.offset;
        int segmentCount = segment.count;
        if (tokenMarker == null) {
            for (int j = 0; j < segmentCount; ++j) {
                char c = segmentArray[j + segmentOffset];
                this.appendToHTML(c, cf);
            }
        } else {
            Token tokens;
            if (painter.getCurrentLineIndex() == line && painter.getCurrentLineTokens() != null) {
                tokens = painter.getCurrentLineTokens();
            } else {
                painter.setCurrentLineIndex(line);
                painter.setCurrentLineTokens(tokenMarker.markTokens(segment, line));
                tokens = painter.getCurrentLineTokens();
            }
            int offset = 0;
            SyntaxStyle[] styles = painter.getStyles();
            while (true) {
                byte id;
                if ((id = tokens.id) == 127) {
                    char c = segmentArray[segmentOffset + offset];
                    if (segmentOffset + offset < limit) {
                        this.appendToHTML(c, cf);
                    } else {
                        cf.append('\n');
                    }
                    return;
                }
                if (id != 0) {
                    if (this.html) {
                        cf.append("<span style=\"color: #");
                        cf.append(PApplet.hex((int)(styles[id].getColor().getRGB() & 0xFFFFFF), (int)6));
                        cf.append(";\">");
                    }
                    if (this.html && styles[id].isBold()) {
                        cf.append("<b>");
                    }
                }
                int length = tokens.length;
                for (int j = 0; j < length; ++j) {
                    char c = segmentArray[segmentOffset + offset + j];
                    if (offset == 0 && c == ' ') {
                        cf.append(this.html ? "&nbsp;" : Character.valueOf('\u00a0'));
                    } else {
                        this.appendToHTML(c, cf);
                    }
                    if (this.html && j == length - 1 && id != 0 && styles[id].isBold()) {
                        cf.append("</b>");
                    }
                    if (!this.html || j != length - 1 || id == 0) continue;
                    cf.append("</span>");
                }
                offset += length;
                tokens = tokens.next;
            }
        }
    }
}

