/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.tools.CharacterSelector;
import processing.app.tools.SampleComponent;
import processing.app.tools.Tool;
import processing.core.PFont;

public class CreateFont
extends JFrame
implements Tool {
    Editor editor;
    Dimension windowSize;
    JList fontSelector;
    JTextField sizeSelector;
    JButton charsetButton;
    JCheckBox smoothBox;
    JComponent sample;
    JButton okButton;
    JTextField filenameField;
    HashMap<String, Font> table;
    boolean smooth = true;
    Font font;
    String[] list;
    int selection = -1;
    CharacterSelector charSelector;

    public CreateFont() {
        super("Create Font");
    }

    @Override
    public String getMenuTitle() {
        return "Create Font...";
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
        Container paine = this.getContentPane();
        paine.setLayout(new BorderLayout());
        JPanel pain = new JPanel();
        pain.setBorder(new EmptyBorder(13, 13, 13, 13));
        paine.add((Component)pain, "Center");
        pain.setLayout(new BoxLayout(pain, 1));
        String labelText = "Use this tool to create bitmap fonts for your program.\nSelect a font and size, and click 'OK' to generate the font.\nIt will be added to the data folder of the current sketch.";
        JTextArea textarea = new JTextArea(labelText);
        textarea.setBorder(new EmptyBorder(10, 10, 20, 10));
        textarea.setBackground(null);
        textarea.setEditable(false);
        textarea.setHighlighter(null);
        textarea.setFont(new Font("Dialog", 0, 12));
        pain.add(textarea);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        String[] flist = new String[fonts.length];
        this.table = new HashMap();
        int index = 0;
        for (int i = 0; i < fonts.length; ++i) {
            flist[index++] = fonts[i].getPSName();
            this.table.put(fonts[i].getPSName(), fonts[i]);
        }
        this.list = new String[index];
        System.arraycopy(flist, 0, this.list, 0, index);
        this.fontSelector = new JList<String>(this.list);
        this.fontSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CreateFont.this.selection = CreateFont.this.fontSelector.getSelectedIndex();
                    CreateFont.this.okButton.setEnabled(true);
                    CreateFont.this.update();
                }
            }
        });
        this.fontSelector.setSelectionMode(0);
        this.fontSelector.setVisibleRowCount(12);
        JScrollPane fontScroller = new JScrollPane(this.fontSelector);
        pain.add(fontScroller);
        Dimension d1 = new Dimension(13, 13);
        pain.add(new Box.Filler(d1, d1, d1));
        this.sample = new SampleComponent(this);
        this.sample.setFont(new Font("Dialog", 0, 12));
        pain.add(this.sample);
        Dimension d2 = new Dimension(6, 6);
        pain.add(new Box.Filler(d2, d2, d2));
        JPanel panel = new JPanel();
        panel.add(new JLabel("Size:"));
        this.sizeSelector = new JTextField(" 48 ");
        this.sizeSelector.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateFont.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        panel.add(this.sizeSelector);
        this.smoothBox = new JCheckBox("Smooth");
        this.smoothBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.smooth = CreateFont.this.smoothBox.isSelected();
                CreateFont.this.update();
            }
        });
        this.smoothBox.setSelected(this.smooth);
        panel.add(this.smoothBox);
        this.charsetButton = new JButton("Characters...");
        this.charsetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.charSelector.setVisible(true);
            }
        });
        panel.add(this.charsetButton);
        pain.add(panel);
        JPanel filestuff = new JPanel();
        filestuff.add(new JLabel("Filename:"));
        this.filenameField = new JTextField(20);
        filestuff.add(this.filenameField);
        filestuff.add(new JLabel(".vlw"));
        pain.add(filestuff);
        JPanel buttons = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.setVisible(false);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFont.this.build();
            }
        });
        this.okButton.setEnabled(false);
        buttons.add(cancelButton);
        buttons.add(this.okButton);
        pain.add(buttons);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(this.okButton);
        ActionListener disposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateFont.this.setVisible(false);
            }
        };
        Base.registerWindowCloseKeys(root, disposer);
        Base.setIcon(this);
        this.setResizable(false);
        this.pack();
        this.sample.setFont(new Font(this.list[0], 0, 48));
        this.fontSelector.setSelectedIndex(0);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowSize = this.getSize();
        this.setLocation((screen.width - this.windowSize.width) / 2, (screen.height - this.windowSize.height) / 2);
        this.charSelector = new CharacterSelector();
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    public void update() {
        int fontsize = 0;
        try {
            fontsize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        if (fontsize > 0 && fontsize < 256 && this.selection != -1) {
            Font instance = this.table.get(this.list[this.selection]);
            this.font = instance.deriveFont(0, fontsize);
            this.sample.setFont(this.font);
            String filenameSuggestion = this.list[this.selection].replace(' ', '_');
            filenameSuggestion = filenameSuggestion + "-" + fontsize;
            this.filenameField.setText(filenameSuggestion);
        }
    }

    public void build() {
        int fontsize = 0;
        try {
            fontsize = Integer.parseInt(this.sizeSelector.getText().trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (fontsize <= 0) {
            JOptionPane.showMessageDialog(this, "Bad font size, try again.", "Badness", 2);
            return;
        }
        String filename = this.filenameField.getText().trim();
        if (filename.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a file name for the font.", "Lameness", 2);
            return;
        }
        if (!filename.endsWith(".vlw")) {
            filename = filename + ".vlw";
        }
        try {
            Font instance = this.table.get(this.list[this.selection]);
            this.font = instance.deriveFont(0, fontsize);
            PFont f = new PFont(this.font, this.smooth, this.charSelector.getCharacters());
            File folder = this.editor.getSketch().prepareDataFolder();
            f.save((OutputStream)new FileOutputStream(new File(folder, filename)));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while creating font.", "No font for you", 2);
            e.printStackTrace();
        }
        this.setVisible(false);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.windowSize.width, 2000);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.windowSize;
    }
}

