/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.I18n;
import processing.app.Preferences;
import processing.core.PApplet;

public class PdePreprocessor {
    public int prototypeCount = 0;
    public int headerCount = 1;
    List<String> prototypes;
    List<String> programImports;
    List<String> codeFolderImports;
    String program;

    public int writePrefix(String program) throws FileNotFoundException {
        program = program + "\n";
        program = this.scrubComments(program);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            program = PdePreprocessor.substituteUnicode(program);
        }
        String importRegexp = "^\\s*#include\\s*[<\"](\\S+)[\">]";
        this.programImports = new ArrayList<String>();
        String[][] pieces = PApplet.matchAll((String)program, (String)importRegexp);
        if (pieces != null) {
            for (int i = 0; i < pieces.length; ++i) {
                this.programImports.add(pieces[i][1]);
            }
        }
        this.codeFolderImports = new ArrayList<String>();
        this.prototypes = this.prototypes(program);
        this.prototypeCount = this.prototypes.size();
        this.program = program;
        return this.headerCount + this.prototypeCount;
    }

    static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] <= '\u007f') continue;
            ++unicodeCount;
        }
        if (unicodeCount != 0) {
            int index = 0;
            char[] p2 = new char[p.length + unicodeCount * 5];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] < '\u0080') {
                    p2[index++] = p[i];
                    continue;
                }
                if (p[i] == '\u00a0') {
                    p2[index++] = 32;
                    continue;
                }
                char c = p[i];
                p2[index++] = 92;
                p2[index++] = 117;
                char[] str = Integer.toHexString(c).toCharArray();
                for (int m = 0; m < 4 - str.length; ++m) {
                    p2[index++] = 48;
                }
                System.arraycopy(str, 0, p2, index, str.length);
                index += str.length;
            }
            program = new String(p2, 0, index);
        }
        return program;
    }

    public void write(OutputStream output) throws Exception {
        PrintStream stream = new PrintStream(output);
        this.writeProgram(stream, this.program, this.prototypes);
        this.writeFooter(stream);
    }

    protected void writeProgram(PrintStream out, String program, List<String> prototypes) {
        int prototypeInsertionPoint = this.firstStatement(program);
        out.print(program.substring(0, prototypeInsertionPoint));
        out.print("#include \"Arduino.h\"\n");
        for (int i = 0; i < prototypes.size(); ++i) {
            out.print(prototypes.get(i) + "\n");
        }
        String[] lines = program.substring(0, prototypeInsertionPoint).split("\n", -1);
        out.println("#line " + (lines.length - 1));
        out.print(program.substring(prototypeInsertionPoint));
    }

    protected void writeFooter(PrintStream out) throws Exception {
    }

    public List<String> getExtraImports() {
        return this.programImports;
    }

    public int firstStatement(String in) {
        String p = "\\s+";
        p = p + "|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)";
        p = p + "|(#(?:\\\\\\n|.)*)";
        Pattern pattern = Pattern.compile(p, 8);
        Matcher matcher = pattern.matcher(in);
        int i = 0;
        while (matcher.find() && matcher.start() == i) {
            i = matcher.end();
        }
        return i;
    }

    public String strip(String in) {
        String p = "('.')";
        p = p + "|('\\\\\"')";
        p = p + "|(\"(?:[^\"\\\\]|\\\\.)*\")";
        p = p + "|(//.*?$)|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)";
        p = p + "|(^\\s*#.*?$)";
        StringBuilder sb = new StringBuilder(in);
        Pattern pattern = Pattern.compile(p, 40);
        Matcher matcher = pattern.matcher(sb);
        while (matcher.find()) {
            String replacement = this.composeReplacementString(new StringBuilder(sb.subSequence(matcher.start(), matcher.end())));
            sb.replace(matcher.start(), matcher.end(), replacement);
        }
        return sb.toString();
    }

    private String composeReplacementString(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\n') continue;
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }

    private String collapseBraces(String in) {
        StringBuffer buffer = new StringBuffer();
        int nesting = 0;
        int start = 0;
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '{') {
                if (nesting == 0) {
                    buffer.append(in.substring(start, i + 1));
                }
                ++nesting;
            }
            if (in.charAt(i) != '}' || --nesting != 0) continue;
            start = i;
        }
        buffer.append(in.substring(start));
        return buffer.toString();
    }

    public ArrayList<String> prototypes(String in) {
        in = this.collapseBraces(this.strip(in));
        Pattern prototypePattern = Pattern.compile("[\\w\\[\\]\\*]+\\s+[&\\[\\]\\*\\w\\s]+\\([&,\\[\\]\\*\\w\\s]*\\)(?=\\s*;)");
        Pattern functionPattern = Pattern.compile("[\\w\\[\\]\\*]+\\s+[&\\[\\]\\*\\w\\s]+\\([&,\\[\\]\\*\\w\\s]*\\)(?=\\s*\\{)");
        ArrayList<String> prototypeMatches = new ArrayList<String>();
        Matcher prototypeMatcher = prototypePattern.matcher(in);
        while (prototypeMatcher.find()) {
            prototypeMatches.add(prototypeMatcher.group(0) + ";");
        }
        ArrayList<String> functionMatches = new ArrayList<String>();
        Matcher functionMatcher = functionPattern.matcher(in);
        while (functionMatcher.find()) {
            functionMatches.add(functionMatcher.group(0) + ";");
        }
        block2: for (int functionIndex = functionMatches.size() - 1; functionIndex >= 0; --functionIndex) {
            for (int prototypeIndex = 0; prototypeIndex < prototypeMatches.size(); ++prototypeIndex) {
                if (!functionMatches.get(functionIndex).equals(prototypeMatches.get(prototypeIndex))) continue;
                functionMatches.remove(functionIndex);
                continue block2;
            }
        }
        return functionMatches;
    }

    private boolean isStartOrEndOfString(char[] p, int index) {
        if (p[index] != '\"') {
            return false;
        }
        if (index == 0) {
            return true;
        }
        if (p[index - 1] == '\\') {
            return false;
        }
        if (index - 2 >= 0 && p[index - 2] == '\\') {
            return true;
        }
        return true;
    }

    public String scrubComments(String what) {
        char[] p = what.toCharArray();
        int index = 0;
        boolean insideString = false;
        while (index < p.length) {
            if (this.isStartOrEndOfString(p, index)) {
                boolean bl = insideString = !insideString;
            }
            if (!insideString && p[index] == '/' && index < p.length - 1 && p[index + 1] == '/') {
                p[index++] = 32;
                p[index++] = 32;
                while (index < p.length && p[index] != '\n') {
                    p[index++] = 32;
                }
                continue;
            }
            if (!insideString && p[index] == '/' && index < p.length - 1 && p[index + 1] == '*') {
                p[index++] = 32;
                p[index++] = 32;
                boolean endOfRainbow = false;
                while (index < p.length - 1) {
                    if (p[index] == '*' && p[index + 1] == '/') {
                        p[index++] = 32;
                        p[index++] = 32;
                        endOfRainbow = true;
                        break;
                    }
                    if (p[index] != '\n') {
                        p[index] = 32;
                    }
                    ++index;
                }
                if (endOfRainbow) continue;
                throw new RuntimeException(I18n._("Missing the */ from the end of a /* comment */"));
            }
            ++index;
        }
        return new String(p);
    }
}

