/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;

public class Library {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String url;
    private String category;
    private String license;
    private List<String> architectures;
    private File folder;
    private File srcFolder;
    private boolean useRecursion;
    private boolean isLegacy;
    private static final List<String> MANDATORY_PROPERTIES = Arrays.asList("name", "version", "author", "maintainer", "sentence", "paragraph", "url");
    private static final List<String> CATEGORIES = Arrays.asList("Display", "Communication", "Signal Input/Output", "Sensors", "Device Control", "Timing", "Data Storage", "Data Processing", "Other", "Uncategorized");
    public static final Comparator<Library> CASE_INSENSITIVE_ORDER = new Comparator<Library>(){

        @Override
        public int compare(Library o1, Library o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public static Library create(File libFolder) throws IOException {
        File check = new File(libFolder, "library.properties");
        if (!check.exists() || !check.isFile()) {
            return Library.createLegacyLibrary(libFolder);
        }
        return Library.createLibrary(libFolder);
    }

    private static Library createLibrary(File libFolder) throws IOException {
        String license;
        boolean useRecursion;
        File archFolder;
        File propertiesFile = new File(libFolder, "library.properties");
        PreferencesMap properties = new PreferencesMap();
        properties.load(propertiesFile);
        if (!properties.containsKey("maintainer") && properties.containsKey("email")) {
            properties.put("maintainer", properties.get("email"));
        }
        if ((archFolder = new File(libFolder, "arch")).isDirectory()) {
            throw new IOException("'arch' folder is no longer supported! See http://goo.gl/gfFJzU for more information");
        }
        for (String p : MANDATORY_PROPERTIES) {
            if (properties.containsKey(p)) continue;
            throw new IOException("Missing '" + p + "' from library");
        }
        File srcFolder = new File(libFolder, "src");
        if (srcFolder.exists() && srcFolder.isDirectory()) {
            useRecursion = true;
            File utilFolder = new File(libFolder, "utility");
            if (utilFolder.exists() && utilFolder.isDirectory()) {
                throw new IOException("Library can't use both 'src' and 'utility' folders.");
            }
        } else {
            srcFolder = libFolder;
            useRecursion = false;
        }
        for (File file : libFolder.listFiles()) {
            if (!file.isDirectory() || !FileUtils.isSCCSOrHiddenFile(file)) continue;
            System.out.println("WARNING: Spurious " + file.getName() + " folder in '" + (String)properties.get("name") + "' library");
        }
        String architectures = (String)properties.get("architectures");
        if (architectures == null) {
            architectures = "*";
        }
        ArrayList<String> archs = new ArrayList<String>();
        for (String arch : architectures.split(",")) {
            archs.add(arch.trim());
        }
        String category = (String)properties.get("category");
        if (category == null) {
            category = "Uncategorized";
        }
        if (!CATEGORIES.contains(category)) {
            category = "Uncategorized";
            System.out.println("WARNING: Category '" + category + "' in library " + (String)properties.get("name") + " is not valid. Setting to 'Uncategorized'");
        }
        if ((license = (String)properties.get("license")) == null) {
            license = "Unspecified";
        }
        Library res = new Library();
        res.folder = libFolder;
        res.srcFolder = srcFolder;
        res.name = ((String)properties.get("name")).trim();
        res.version = ((String)properties.get("version")).trim();
        res.author = ((String)properties.get("author")).trim();
        res.maintainer = ((String)properties.get("maintainer")).trim();
        res.sentence = ((String)properties.get("sentence")).trim();
        res.paragraph = ((String)properties.get("paragraph")).trim();
        res.url = ((String)properties.get("url")).trim();
        res.category = category.trim();
        res.license = license.trim();
        res.architectures = archs;
        res.useRecursion = useRecursion;
        res.isLegacy = false;
        return res;
    }

    private static Library createLegacyLibrary(File libFolder) {
        Library res = new Library();
        res.folder = libFolder;
        res.srcFolder = libFolder;
        res.useRecursion = false;
        res.name = libFolder.getName();
        res.architectures = Arrays.asList("*");
        res.isLegacy = true;
        return res;
    }

    public boolean supportsArchitecture(String reqArch) {
        return this.architectures.contains(reqArch) || this.architectures.contains("*");
    }

    public boolean supportsArchitecture(List<String> reqArchs) {
        if (reqArchs.contains("*")) {
            return true;
        }
        for (String reqArch : reqArchs) {
            if (!this.supportsArchitecture(reqArch)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLicense() {
        return this.license;
    }

    public static List<String> getCategories() {
        return CATEGORIES;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public boolean useRecursion() {
        return this.useRecursion;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public String toString() {
        String res = "Library:";
        res = res + " (name=" + this.name + ")";
        res = res + " (version=" + this.version + ")";
        res = res + " (author=" + this.author + ")";
        res = res + " (maintainer=" + this.maintainer + ")";
        res = res + " (sentence=" + this.sentence + ")";
        res = res + " (paragraph=" + this.paragraph + ")";
        res = res + " (url=" + this.url + ")";
        res = res + " (architectures=" + this.architectures + ")";
        return res;
    }
}

