/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import com.apple.eio.FileManager;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import javax.swing.UIManager;
import org.apache.commons.exec.CommandLine;
import processing.app.Base;
import processing.app.debug.TargetPackage;
import processing.app.macosx.SystemProfilerParser;
import processing.app.macosx.ThinkDifferent;
import processing.app.tools.ExternalProcessExecutor;
import processing.core.PApplet;
import processing.core.PConstants;

public class Platform
extends processing.app.Platform {
    static final int kDocumentsFolderType = 1685021555;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;

    @Override
    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
        UIManager.put("Component.visualMargin", new Insets(1, 1, 1, 1));
    }

    public Platform() {
        Toolkit.getDefaultToolkit();
    }

    @Override
    public void init(Base base) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ThinkDifferent.init(base);
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Arduino15");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        if (PApplet.javaVersion < 1.6f) {
            if (url.startsWith("http://")) {
                try {
                    Class<?> eieio = Class.forName("com.apple.eio.FileManager");
                    Method openMethod = eieio.getMethod("openURL", String.class);
                    openMethod.invoke(null, url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PApplet.open((String)url);
            }
        } else {
            try {
                Class<?> desktopClass = Class.forName("java.awt.Desktop");
                Method getMethod = desktopClass.getMethod("getDesktop", new Class[0]);
                Object desktop = getMethod.invoke(null, new Object[0]);
                if (url.startsWith("http://")) {
                    Method browseMethod = desktopClass.getMethod("browse", URI.class);
                    browseMethod.invoke(desktop, new URI(url));
                } else {
                    Method openMethod = desktopClass.getMethod("open", File.class);
                    openMethod.invoke(desktop, new File(url));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        PApplet.open((String)file.getAbsolutePath());
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }

    @Override
    public String getName() {
        return PConstants.platformNames[2];
    }

    @Override
    public String resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        if (devicesListOutput == null) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
        try {
            String vidPid = new SystemProfilerParser().extractVIDAndPID(devicesListOutput, serial);
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExternalProcessExecutor executor = new ExternalProcessExecutor(baos);
        try {
            CommandLine toDevicePath = CommandLine.parse((String)"/usr/sbin/system_profiler SPUSBDataType");
            executor.execute(toDevicePath);
            return new String(baos.toByteArray());
        }
        catch (Throwable e) {
            return super.preListAllCandidateDevices();
        }
    }
}

