/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.UIManager;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.core.PConstants;

public class Platform {
    Base base;

    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public void init(Base base) {
        this.base = base;
    }

    public File getSettingsFolder() throws Exception {
        File home2 = new File(System.getProperty("user.home"));
        File dataFolder = new File(home2, ".arduino15");
        return dataFolder;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return null;
    }

    public void openURL(String url) throws Exception {
        String launcher = Preferences.get("launcher");
        if (launcher != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        } else {
            this.showLauncherWarning();
        }
    }

    public boolean openFolderAvailable() {
        return Preferences.get("launcher") != null;
    }

    public void openFolder(File file) throws Exception {
        String launcher = Preferences.get("launcher");
        if (launcher != null) {
            String folder = file.getAbsolutePath();
            Runtime.getRuntime().exec(new String[]{launcher, folder});
        } else {
            this.showLauncherWarning();
        }
    }

    public String resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        return null;
    }

    public String preListAllCandidateDevices() {
        return null;
    }

    protected String resolveDeviceByVendorIdProductId(Map<String, TargetPackage> packages, String readVIDPID) {
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    LinkedList vids = new LinkedList(board.getPreferences().subTree("vid").values());
                    if (vids.isEmpty()) continue;
                    LinkedList pids = new LinkedList(board.getPreferences().subTree("pid").values());
                    for (int i = 0; i < vids.size(); ++i) {
                        String vidPid = (String)vids.get(i) + "_" + (String)pids.get(i);
                        if (!vidPid.toUpperCase().equals(readVIDPID)) continue;
                        return board.getName();
                    }
                }
            }
        }
        return null;
    }

    public String resolveDeviceByBoardID(Map<String, TargetPackage> packages, String boardId) {
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (!boardId.equals(board.getId())) continue;
                    return board.getName();
                }
            }
        }
        return null;
    }

    public void setenv(String variable, String value) {
        CLibrary clib = CLibrary.INSTANCE;
        clib.setenv(variable, value, 1);
    }

    public String getenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.getenv(variable);
    }

    public int unsetenv(String variable) {
        CLibrary clib = CLibrary.INSTANCE;
        return clib.unsetenv(variable);
    }

    public String getName() {
        return PConstants.platformNames[0];
    }

    protected void showLauncherWarning() {
        Base.showWarning(I18n._("No launcher available"), I18n._("Unspecified platform, no launcher available.\nTo enable opening URLs or folders, add a \n\"launcher=/path/to/app\" line to preferences.txt"), null);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int setenv(String var1, String var2, int var3);

        public String getenv(String var1);

        public int unsetenv(String var1);

        public int putenv(String var1);
    }
}

