/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.ssh.NoInteractionUserInfo;
import cc.arduino.packages.ssh.SSHConfigFileSetup;
import cc.arduino.packages.ssh.SSHPwdSetup;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import processing.app.AbstractMonitor;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.debug.MessageSiphon;

public class NetworkMonitor
extends AbstractMonitor {
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private final BoardPort port;
    private final String ipAddress;
    private MessageSiphon inputConsumer;
    private Session session;
    private Channel channel;
    private MessageSiphon errorConsumer;
    private int connectionAttempts;

    public NetworkMonitor(BoardPort port, Base base) {
        super(port.getLabel());
        this.port = port;
        this.ipAddress = port.getAddress();
        this.onSendCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    OutputStream out = NetworkMonitor.this.channel.getOutputStream();
                    out.write(NetworkMonitor.this.textField.getText().getBytes());
                    out.write(10);
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                NetworkMonitor.this.textField.setText("");
            }
        });
    }

    @Override
    public boolean requiresAuthorization() {
        return true;
    }

    @Override
    public String getAuthorizationKey() {
        return "runtime.pwd." + this.ipAddress;
    }

    @Override
    public void open() throws Exception {
        this.connectionAttempts = 0;
        JSch jSch = new JSch();
        SSHConfigFileSetup sshClientSetupChain = new SSHConfigFileSetup(new SSHPwdSetup());
        this.session = sshClientSetupChain.setup(this.port, jSch);
        this.session.setUserInfo((UserInfo)new NoInteractionUserInfo(Preferences.get(this.getAuthorizationKey())));
        this.session.connect(30000);
        this.tryConnect();
    }

    private void tryConnect() throws JSchException, IOException {
        ++this.connectionAttempts;
        if (this.connectionAttempts > 1) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.session.isConnected()) {
            return;
        }
        this.channel = this.session.openChannel("exec");
        ((ChannelExec)this.channel).setCommand("telnet localhost 6571");
        InputStream inputStream = this.channel.getInputStream();
        InputStream errStream = ((ChannelExec)this.channel).getErrStream();
        this.channel.connect();
        this.inputConsumer = new MessageSiphon(inputStream, this);
        this.errorConsumer = new MessageSiphon(errStream, this);
        if (this.connectionAttempts > 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (NetworkMonitor.this.channel.isConnected()) {
                        NetworkMonitor.this.message(I18n._("connected!") + '\n');
                    }
                }
            });
        }
    }

    @Override
    public synchronized void message(String s) {
        if (s.contains("can't connect")) {
            while (!this.channel.isClosed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.connectionAttempts < 5) {
                s = "\n" + I18n._("Unable to connect: retrying") + " (" + this.connectionAttempts + ")... ";
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NetworkMonitor.this.tryConnect();
                        }
                        catch (JSchException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                s = "\n" + I18n._("Unable to connect: is the sketch using the bridge?");
            }
        }
        super.message(s);
    }

    @Override
    public void close() throws Exception {
        if (this.channel != null) {
            this.inputConsumer.stop();
            this.channel.disconnect();
            this.textArea.setText("");
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }
}

