/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Theme;

public class EditorStatus
extends JPanel {
    static Color[] bgcolor;
    static Color[] fgcolor;
    static final int NOTICE = 0;
    static final int ERR = 1;
    static final int EDIT = 2;
    static final int PROGRESS = 5;
    static final int YES = 1;
    static final int NO = 2;
    static final int CANCEL = 3;
    static final int OK = 4;
    static final String NO_MESSAGE = "";
    Editor editor;
    int mode;
    String message;
    Font font;
    FontMetrics metrics;
    int ascent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    JButton cancelButton;
    JButton okButton;
    JTextField editField;
    JProgressBar progressBar;
    JButton copyErrorButton;
    int response;
    boolean initialized = false;

    public EditorStatus(Editor editor) {
        this.editor = editor;
        this.empty();
        if (bgcolor == null) {
            bgcolor = new Color[6];
            EditorStatus.bgcolor[0] = Theme.getColor("status.notice.bgcolor");
            EditorStatus.bgcolor[1] = Theme.getColor("status.error.bgcolor");
            EditorStatus.bgcolor[2] = Theme.getColor("status.edit.bgcolor");
            EditorStatus.bgcolor[3] = null;
            EditorStatus.bgcolor[4] = null;
            EditorStatus.bgcolor[5] = Theme.getColor("status.notice.bgcolor");
            fgcolor = new Color[6];
            EditorStatus.fgcolor[0] = Theme.getColor("status.notice.fgcolor");
            EditorStatus.fgcolor[1] = Theme.getColor("status.error.fgcolor");
            EditorStatus.fgcolor[2] = Theme.getColor("status.edit.fgcolor");
            EditorStatus.fgcolor[3] = null;
            EditorStatus.fgcolor[4] = null;
            EditorStatus.fgcolor[5] = Theme.getColor("status.notice.fgcolor");
        }
    }

    public void empty() {
        this.mode = 0;
        this.message = NO_MESSAGE;
        this.repaint();
    }

    public void notice(String message) {
        this.mode = 0;
        this.message = message;
        if (this.copyErrorButton != null) {
            this.copyErrorButton.setVisible(false);
        }
        this.repaint();
    }

    public void unnotice(String unmessage) {
        if (this.message.equals(unmessage)) {
            this.empty();
        }
    }

    public void error(String message) {
        this.mode = 1;
        this.message = message;
        if (this.copyErrorButton != null) {
            this.copyErrorButton.setVisible(true);
        }
        this.repaint();
    }

    public void edit(String message, String dflt) {
        this.mode = 2;
        this.message = message;
        this.response = 0;
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        this.editField.setVisible(true);
        this.editField.setText(dflt);
        this.editField.selectAll();
        this.editField.requestFocus();
        this.repaint();
    }

    public void unedit() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.editField.setVisible(false);
        this.empty();
    }

    public void progress(String message) {
        this.mode = 5;
        this.message = message;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(true);
        this.copyErrorButton.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.repaint();
    }

    public void progressIndeterminate(String message) {
        this.mode = 5;
        this.message = message;
        this.progressBar.setIndeterminate(true);
        this.progressBar.setValue(50);
        this.progressBar.setVisible(true);
        this.copyErrorButton.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.repaint();
    }

    public void progressNotice(String message) {
        this.message = message;
        this.repaint();
    }

    public void unprogress() {
        if (Preferences.getBoolean("editor.beep.compile")) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.progressBar == null) {
            return;
        }
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
        this.setCursor(null);
    }

    public void progressUpdate(int value) {
        if (this.progressBar == null) {
            return;
        }
        this.progressBar.setValue(value);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics screen) {
        if (!this.initialized) {
            this.setup();
            this.initialized = true;
        }
        Dimension size = this.getSize();
        if (size.width != this.sizeW || size.height != this.sizeH) {
            if (size.width > this.imageW || size.height > this.imageH) {
                this.offscreen = null;
            } else {
                this.sizeW = size.width;
                this.sizeH = size.height;
                this.setButtonBounds();
            }
        }
        if (this.offscreen == null) {
            this.sizeW = size.width;
            this.sizeH = size.height;
            this.setButtonBounds();
            this.imageW = this.sizeW;
            this.imageH = this.sizeH;
            this.offscreen = this.createImage(this.imageW, this.imageH);
        }
        Graphics g = this.offscreen.getGraphics();
        if (this.font == null) {
            this.font = Theme.getFont("status.font");
            g.setFont(this.font);
            this.metrics = g.getFontMetrics();
            this.ascent = this.metrics.getAscent();
        }
        g.setColor(bgcolor[this.mode]);
        g.fillRect(0, 0, this.imageW, this.imageH);
        g.setColor(fgcolor[this.mode]);
        g.setFont(this.font);
        g.drawString(this.message, 6, (this.sizeH + this.ascent) / 2);
        screen.drawImage(this.offscreen, 0, 0, null);
    }

    protected void setup() {
        if (this.okButton == null) {
            this.cancelButton = new JButton(I18n.PROMPT_CANCEL);
            this.okButton = new JButton(I18n.PROMPT_OK);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditorStatus.this.mode == 2) {
                        EditorStatus.this.unedit();
                    }
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditorStatus.this.mode == 2) {
                        String answer = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(answer);
                        EditorStatus.this.unedit();
                    }
                }
            });
            if (Base.isMacOS()) {
                this.cancelButton.setBackground(bgcolor[2]);
                this.okButton.setBackground(bgcolor[2]);
            }
            this.setLayout(null);
            this.add(this.cancelButton);
            this.add(this.okButton);
            this.cancelButton.setVisible(false);
            this.okButton.setVisible(false);
            this.editField = new JTextField();
            this.editField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    if (event.getKeyChar() == '\u001b') {
                        EditorStatus.this.unedit();
                        event.consume();
                    }
                }

                @Override
                public void keyTyped(KeyEvent event) {
                    char c = event.getKeyChar();
                    if (c == '\n') {
                        String answer = EditorStatus.this.editField.getText();
                        EditorStatus.this.editor.getSketch().nameCode(answer);
                        EditorStatus.this.unedit();
                        event.consume();
                    } else if (c != '\b' && c != '\u007f' && c != '\'' && c != '%' && c != '&' && c != '(' && c != '$' && c != '#' && c != '\u0010') {
                        if (c == ' ') {
                            String t = EditorStatus.this.editField.getText();
                            int start = EditorStatus.this.editField.getSelectionStart();
                            int end2 = EditorStatus.this.editField.getSelectionEnd();
                            EditorStatus.this.editField.setText(t.substring(0, start) + "_" + t.substring(end2));
                            EditorStatus.this.editField.setCaretPosition(start + 1);
                            event.consume();
                        } else if (!(c == '_' || c == '.' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                            if (c >= '0' && c <= '9') {
                                if (EditorStatus.this.editField.getCaretPosition() == 0 || EditorStatus.this.editField.getSelectionStart() == 0) {
                                    event.consume();
                                }
                            } else {
                                event.consume();
                            }
                        }
                    }
                }
            });
            this.add(this.editField);
            this.editField.setVisible(false);
            this.progressBar = new JProgressBar(0);
            this.progressBar.setIndeterminate(false);
            if (Base.isMacOS()) {
                // empty if block
            }
            this.progressBar.setValue(0);
            this.progressBar.setBorderPainted(true);
            this.add(this.progressBar);
            this.progressBar.setVisible(false);
            this.copyErrorButton = new JButton(I18n._("Copy error messages"));
            this.add(this.copyErrorButton);
            this.copyErrorButton.setVisible(false);
            this.copyErrorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String message = EditorStatus.NO_MESSAGE;
                    message = message + I18n._("Arduino: ") + Base.VERSION_NAME + " (" + System.getProperty("os.name") + "), ";
                    message = message + I18n._("Board: ") + "\"" + (String)Base.getBoardPreferences().get("name") + "\"\n\n";
                    message = message + EditorStatus.this.editor.console.consoleTextPane.getText().trim();
                    if (!Preferences.getBoolean("build.verbose")) {
                        message = message + "\n\n";
                        message = message + "  " + I18n._("This report would have more information with") + "\n";
                        message = message + "  \"" + I18n._("Show verbose output during compilation") + "\"\n";
                        message = message + "  " + I18n._("enabled in File > Preferences.") + "\n";
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection data = new StringSelection(message);
                    clipboard.setContents(data, null);
                    Clipboard unixclipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                    if (unixclipboard != null) {
                        unixclipboard.setContents(data, null);
                    }
                }
            });
        }
    }

    protected void setButtonBounds() {
        int top = (this.sizeH - Preferences.BUTTON_HEIGHT) / 2;
        int eachButton = 6 + Preferences.BUTTON_WIDTH;
        int cancelLeft = this.sizeW - eachButton;
        int noLeft = cancelLeft - eachButton;
        int yesLeft = noLeft - eachButton;
        this.cancelButton.setLocation(cancelLeft, top);
        this.okButton.setLocation(noLeft, top);
        this.progressBar.setLocation(noLeft, top);
        this.cancelButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.okButton.setSize(Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        this.progressBar.setSize(2 * Preferences.BUTTON_WIDTH, Preferences.BUTTON_HEIGHT);
        int editWidth = 2 * Preferences.BUTTON_WIDTH;
        int editHeight = this.editField.getPreferredSize().height;
        int editTop = (1 + this.sizeH - editHeight) / 2;
        this.editField.setBounds(yesLeft - Preferences.BUTTON_WIDTH, editTop, editWidth, editHeight);
        this.progressBar.setBounds(noLeft, editTop, editWidth, editHeight);
        Dimension copyErrorButtonSize = this.copyErrorButton.getPreferredSize();
        this.copyErrorButton.setLocation(this.sizeW - copyErrorButtonSize.width - 5, top);
        this.copyErrorButton.setSize(copyErrorButtonSize.width, Preferences.BUTTON_HEIGHT);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 33);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, 33);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            if (this.mode == 2) {
                this.unedit();
            }
        } else if (e.getSource() == this.okButton && this.mode == 2) {
            String answer = this.editField.getText();
            this.editor.getSketch().nameCode(answer);
            this.unedit();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

