/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Base;
import processing.app.BufferedStyledDocument;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Theme;

public class EditorConsole
extends JScrollPane {
    Editor editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet stdStyle;
    MutableAttributeSet errStyle;
    int maxLineCount;
    static File errFile;
    static File outFile;
    static File tempFolder;
    public static PrintStream systemOut;
    public static PrintStream systemErr;
    static PrintStream consoleOut;
    static PrintStream consoleErr;
    static OutputStream stdoutFile;
    static OutputStream stderrFile;
    static EditorConsole currentConsole;

    public EditorConsole(Editor editor) {
        this.editor = editor;
        this.maxLineCount = Preferences.getInteger("console.length");
        this.consoleDoc = new BufferedStyledDocument(10000, this.maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, standard, true);
        Color bgColor = Theme.getColor("console.color");
        Color fgColorOut = Theme.getColor("console.output.color");
        Color fgColorErr = Theme.getColor("console.error.color");
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = Preferences.getFont("editor.font");
        Font font = new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize());
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, fgColorOut);
        StyleConstants.setBackground(this.stdStyle, bgColor);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, fgColorErr);
        StyleConstants.setBackground(this.errStyle, bgColor);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        this.consoleTextPane.setBackground(bgColor);
        this.setViewportView(this.consoleTextPane);
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = Preferences.getInteger("console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 4 + sizeFudge));
        if (systemOut == null) {
            systemOut = System.out;
            systemErr = System.err;
            tempFolder = Base.createTempFolder("console");
            tempFolder.deleteOnExit();
            try {
                String errFileName;
                String outFileName = Preferences.get("console.output.file");
                if (outFileName != null) {
                    outFile = new File(tempFolder, outFileName);
                    outFile.deleteOnExit();
                    stdoutFile = new FileOutputStream(outFile);
                }
                if ((errFileName = Preferences.get("console.error.file")) != null) {
                    errFile = new File(tempFolder, errFileName);
                    errFile.deleteOnExit();
                    stderrFile = new FileOutputStream(errFile);
                }
            }
            catch (IOException e) {
                Base.showWarning(I18n._("Console Error"), I18n._("A problem occurred while trying to open the\nfiles used to store the console output."), e);
            }
            consoleOut = new PrintStream(new EditorConsoleStream(false));
            consoleErr = new PrintStream(new EditorConsoleStream(true));
            if (Preferences.getBoolean("console")) {
                try {
                    System.setOut(consoleOut);
                    System.setErr(consoleErr);
                }
                catch (Exception e) {
                    e.printStackTrace(systemOut);
                }
            }
        }
        if (Base.isMacOS()) {
            this.setBorder(null);
        }
        new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorConsole.this.consoleDoc.hasAppendage) {
                            EditorConsole.this.consoleDoc.insertAll();
                            EditorConsole.this.consoleTextPane.setCaretPosition(EditorConsole.this.consoleDoc.getLength());
                        }
                    }
                });
            }
        }).start();
    }

    public static void setEditor(Editor editor) {
        currentConsole = editor.console;
    }

    public void handleQuit() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        consoleOut.close();
        consoleErr.close();
        try {
            stdoutFile.close();
            stderrFile.close();
        }
        catch (IOException e) {
            e.printStackTrace(systemOut);
        }
        outFile.delete();
        errFile.delete();
        tempFolder.delete();
    }

    public void write(byte[] b, int offset, int length, boolean err) {
        this.message(new String(b, offset, length), err, false);
    }

    public synchronized void message(String what, boolean err, boolean advance) {
        if (err) {
            systemErr.print(what);
        } else {
            systemOut.print(what);
        }
        if (advance) {
            this.appendText("\n", err);
            if (err) {
                systemErr.println();
            } else {
                systemOut.println();
            }
        }
        this.appendText(what, err);
    }

    private synchronized void appendText(String txt, boolean e) {
        this.consoleDoc.appendString(txt, e ? this.errStyle : this.stdStyle);
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static class EditorConsoleStream
    extends OutputStream {
        final boolean err;
        final byte[] single = new byte[1];

        public EditorConsoleStream(boolean err) {
            this.err = err;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b) {
            OutputStream echo;
            if (currentConsole != null) {
                currentConsole.write(b, 0, b.length, this.err);
            } else {
                try {
                    if (this.err) {
                        systemErr.write(b);
                    } else {
                        systemOut.write(b);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    echo = null;
                }
            }
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            OutputStream echo;
            if (currentConsole != null) {
                currentConsole.write(b, offset, length, this.err);
            } else if (this.err) {
                systemErr.write(b, offset, length);
            } else {
                systemOut.write(b, offset, length);
            }
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b, offset, length);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    echo = null;
                }
            }
        }

        @Override
        public void write(int b) {
            OutputStream echo;
            this.single[0] = (byte)b;
            if (currentConsole != null) {
                currentConsole.write(this.single, 0, 1, this.err);
            } else {
                this.write(new byte[]{(byte)b}, 0, 1);
            }
            OutputStream outputStream = echo = this.err ? stderrFile : stdoutFile;
            if (echo != null) {
                try {
                    echo.write(b);
                    echo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    echo = null;
                }
            }
        }
    }
}

