/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.ssh.NoInteractionUserInfo;
import cc.arduino.packages.ssh.SCP;
import cc.arduino.packages.ssh.SSH;
import cc.arduino.packages.ssh.SSHConfigFileSetup;
import cc.arduino.packages.ssh.SSHPwdSetup;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringUtils;

public class SSHUploader
extends Uploader {
    private static final List<String> FILES_NOT_TO_COPY = Arrays.asList(".DS_Store", ".Trash", "Thumbs.db", "__MACOSX");
    private final BoardPort port;

    public SSHUploader(BoardPort port) {
        this.port = port;
    }

    @Override
    public boolean requiresAuthorization() {
        return true;
    }

    @Override
    public String getAuthorizationKey() {
        return "runtime.pwd." + this.port.getAddress();
    }

    @Override
    public boolean uploadUsingPreferences(File sourcePath, String buildPath, String className, boolean usingProgrammer, List<String> warningsAccumulator) throws RunnerException {
        if (usingProgrammer) {
            throw new RunnerException(I18n._("Network upload using programmer not supported"));
        }
        Session session = null;
        SCP scp = null;
        try {
            JSch jSch = new JSch();
            SSHConfigFileSetup sshClientSetupChain = new SSHConfigFileSetup(new SSHPwdSetup());
            session = sshClientSetupChain.setup(this.port, jSch);
            session.setUserInfo((UserInfo)new NoInteractionUserInfo(Preferences.get("runtime.pwd." + this.port.getAddress())));
            session.connect(30000);
            scp = new SCP(session);
            SSH ssh = new SSH(session);
            this.scpFiles(scp, ssh, sourcePath, buildPath, className, warningsAccumulator);
            boolean bl = this.runAVRDude(ssh);
            return bl;
        }
        catch (JSchException e) {
            String message = e.getMessage();
            if ("Auth cancel".equals(message) || "Auth fail".equals(message)) {
                boolean bl = false;
                return bl;
            }
            if (e.getMessage().contains("Connection refused")) {
                throw new RunnerException(I18n.format("Unable to connect to {0}", this.port.getAddress()));
            }
            throw new RunnerException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        finally {
            if (scp != null) {
                try {
                    scp.close();
                }
                catch (IOException e) {
                    throw new RunnerException(e);
                }
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private boolean runAVRDude(SSH ssh) throws IOException, JSchException {
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        PreferencesMap prefs = Preferences.getMap();
        prefs.putAll(Base.getBoardPreferences());
        prefs.putAll(targetPlatform.getTool((String)prefs.get("upload.tool")));
        String additionalParams = this.verbose ? (String)prefs.get("upload.params.verbose") : (String)prefs.get("upload.params.quiet");
        boolean success = ssh.execSyncCommand("merge-sketch-with-bootloader.lua /tmp/sketch.hex", System.out, System.err);
        ssh.execSyncCommand("kill-bridge");
        success = success && ssh.execSyncCommand("run-avrdude /tmp/sketch.hex '" + additionalParams + "'", System.out, System.err);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scpFiles(SCP scp, SSH ssh, File sourcePath, String buildPath, String className, List<String> warningsAccumulator) throws JSchException, IOException {
        try {
            scp.open();
            scp.startFolder("tmp");
            scp.sendFile(new File(buildPath, className + ".hex"), "sketch.hex");
            scp.endFolder();
            if (this.canUploadWWWFiles(sourcePath, ssh, warningsAccumulator)) {
                scp.startFolder("www");
                scp.startFolder("sd");
                scp.startFolder(sourcePath.getName());
                this.recursiveSCP(new File(sourcePath, "www"), scp);
                scp.endFolder();
                scp.endFolder();
                scp.endFolder();
            }
        }
        finally {
            scp.close();
        }
    }

    private boolean canUploadWWWFiles(File sourcePath, SSH ssh, List<String> warningsAccumulator) throws IOException, JSchException {
        File www = new File(sourcePath, "www");
        if (!www.exists() || !www.isDirectory()) {
            return false;
        }
        if (!www.canExecute()) {
            warningsAccumulator.add(I18n._("Problem accessing files in folder ") + www);
            return false;
        }
        if (!ssh.execSyncCommand("special-storage-available")) {
            warningsAccumulator.add(I18n._("Problem accessing board folder /www/sd"));
            return false;
        }
        return true;
    }

    private void recursiveSCP(File from, SCP scp) throws IOException {
        File[] files = from.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (StringUtils.stringContainsOneOf(file.getName(), FILES_NOT_TO_COPY)) continue;
            if (file.isDirectory() && file.canExecute()) {
                scp.startFolder(file.getName());
                this.recursiveSCP(file, scp);
                scp.endFolder();
                continue;
            }
            if (!file.isFile() || !file.canRead()) continue;
            scp.sendFile(file);
        }
    }

    @Override
    public boolean burnBootloader() throws RunnerException {
        throw new RunnerException("Can't burn bootloader via SSH");
    }
}

