/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import java.util.ArrayList;
import java.util.List;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Serial;
import processing.app.helpers.PreferencesMap;

public class SerialDiscovery
implements Discovery {
    @Override
    public List<BoardPort> discovery() {
        Platform os = Base.getPlatform();
        String devicesListOutput = os.preListAllCandidateDevices();
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        List<String> ports = Serial.list();
        for (String port : ports) {
            String boardName = os.resolveDeviceAttachedTo(port, Base.packages, devicesListOutput);
            String label = port;
            if (boardName != null) {
                label = label + " (" + boardName + ")";
            }
            BoardPort boardPort = new BoardPort();
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            boardPort.setBoardName(boardName);
            boardPort.setLabel(label);
            res.add(boardPort);
        }
        return res;
    }

    @Override
    public void setPreferences(PreferencesMap options) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

