/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.network.NetworkChecker;
import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.DNSTaskStarter;
import processing.app.Base;
import processing.app.helpers.NetUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.zeroconf.jmdns.ArduinoDNSTaskStarter;

public class NetworkDiscovery
implements Discovery,
ServiceListener,
NetworkTopologyListener {
    private Timer timer;
    private final List<BoardPort> ports;
    private final Map<InetAddress, JmDNS> mappedJmDNSs;

    public NetworkDiscovery() {
        DNSTaskStarter.Factory.setClassDelegate((DNSTaskStarter.Factory.ClassDelegate)new ArduinoDNSTaskStarter());
        this.ports = new ArrayList<BoardPort>();
        this.mappedJmDNSs = new Hashtable<InetAddress, JmDNS>();
    }

    @Override
    public List<BoardPort> discovery() {
        List<BoardPort> ports = this.clonePortsList();
        Iterator<BoardPort> iterator = ports.iterator();
        while (iterator.hasNext()) {
            try {
                BoardPort board = iterator.next();
                if (NetUtils.isReachable(InetAddress.getByName(board.getAddress()), Integer.parseInt((String)board.getPrefs().get("port")))) continue;
                iterator.remove();
            }
            catch (UnknownHostException e) {
                iterator.remove();
            }
        }
        return ports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BoardPort> clonePortsList() {
        NetworkDiscovery networkDiscovery = this;
        synchronized (networkDiscovery) {
            return new ArrayList<BoardPort>(this.ports);
        }
    }

    @Override
    public void setPreferences(PreferencesMap options) {
    }

    @Override
    public void start() throws IOException {
        this.timer = new Timer(this.getClass().getName() + " timer");
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this.timer);
    }

    @Override
    public void stop() throws IOException {
        this.timer.purge();
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        String type = serviceEvent.getType();
        String name = serviceEvent.getName();
        JmDNS dns = serviceEvent.getDNS();
        dns.requestServiceInfo(type, name);
        ServiceInfo serviceInfo = dns.getServiceInfo(type, name);
        if (serviceInfo != null) {
            dns.requestServiceInfo(type, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceEvent serviceEvent) {
        String name = serviceEvent.getName();
        NetworkDiscovery networkDiscovery = this;
        synchronized (networkDiscovery) {
            for (BoardPort port : this.ports) {
                if (!port.getBoardName().equals(name)) continue;
                this.ports.remove(port);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(ServiceEvent serviceEvent) {
        ServiceInfo info = serviceEvent.getInfo();
        for (Inet4Address inetAddress : info.getInet4Addresses()) {
            String address = ((InetAddress)inetAddress).getHostAddress();
            String name = serviceEvent.getName();
            PreferencesMap prefs = null;
            String board = null;
            if (info.hasData()) {
                prefs = new PreferencesMap();
                board = info.getPropertyString("board");
                prefs.put("board", board);
                prefs.put("distro_version", info.getPropertyString("distro_version"));
            }
            prefs.put("port", "" + info.getPort());
            String label = name + " at " + address;
            if (board != null) {
                String boardName = Base.getPlatform().resolveDeviceByBoardID(Base.packages, board);
                label = label + " (" + boardName + ")";
            }
            BoardPort port = new BoardPort();
            port.setAddress(address);
            port.setBoardName(name);
            port.setProtocol("network");
            port.setPrefs(prefs);
            port.setLabel(label);
            NetworkDiscovery networkDiscovery = this;
            synchronized (networkDiscovery) {
                this.removeDuplicateBoards(port);
                this.ports.add(port);
            }
        }
    }

    private void removeDuplicateBoards(BoardPort newBoard) {
        Iterator<BoardPort> iterator = this.ports.iterator();
        while (iterator.hasNext()) {
            BoardPort board = iterator.next();
            if (!newBoard.getAddress().equals(board.getAddress())) continue;
            iterator.remove();
        }
    }

    @Override
    public void inetAddressAdded(InetAddress address) {
        if (this.mappedJmDNSs.containsKey(address)) {
            return;
        }
        try {
            JmDNS jmDNS = JmDNS.create((InetAddress)address);
            jmDNS.addServiceListener("_arduino._tcp.local.", (ServiceListener)this);
            this.mappedJmDNSs.put(address, jmDNS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void inetAddressRemoved(InetAddress address) {
        JmDNS jmDNS = this.mappedJmDNSs.remove(address);
        if (jmDNS != null) {
            try {
                jmDNS.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

