/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.uploaders.SSHUploader;
import cc.arduino.packages.uploaders.SerialUploader;
import processing.app.AbstractMonitor;
import processing.app.Base;
import processing.app.NetworkMonitor;
import processing.app.SerialMonitor;
import processing.app.debug.TargetBoard;

public class UploaderAndMonitorFactory {
    public Uploader newUploader(TargetBoard board, BoardPort port) {
        if ("true".equals(board.getPreferences().get("upload.via_ssh")) && port != null && "network".equals(port.getProtocol())) {
            return new SSHUploader(port);
        }
        return new SerialUploader();
    }

    public AbstractMonitor newMonitor(BoardPort port, Base base) {
        if ("network".equals(port.getProtocol())) {
            return new NetworkMonitor(port, base);
        }
        return new SerialMonitor(port);
    }
}

