/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PApplet;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class PMatrix2D
implements PMatrix {
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;

    public PMatrix2D() {
        this.reset();
    }

    public PMatrix2D(float f, float f2, float f3, float f4, float f5, float f6) {
        this.set(f, f2, f3, f4, f5, f6);
    }

    public PMatrix2D(PMatrix pMatrix) {
        this.set(pMatrix);
    }

    @Override
    public void reset() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public PMatrix2D get() {
        PMatrix2D pMatrix2D = new PMatrix2D();
        pMatrix2D.set(this);
        return pMatrix2D;
    }

    @Override
    public float[] get(float[] fArray) {
        if (fArray == null || fArray.length != 6) {
            fArray = new float[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        }
        return fArray;
    }

    @Override
    public void set(PMatrix pMatrix) {
        if (!(pMatrix instanceof PMatrix2D)) {
            throw new IllegalArgumentException("PMatrix2D.set() only accepts PMatrix2D objects.");
        }
        PMatrix2D pMatrix2D = (PMatrix2D)pMatrix;
        this.set(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    public void set(PMatrix3D pMatrix3D) {
    }

    @Override
    public void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
    }

    @Override
    public void set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
    }

    @Override
    public void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
    }

    @Override
    public void translate(float f, float f2) {
        this.m02 = f * this.m00 + f2 * this.m01 + this.m02;
        this.m12 = f * this.m10 + f2 * this.m11 + this.m12;
    }

    @Override
    public void translate(float f, float f2, float f3) {
        throw new IllegalArgumentException("Cannot use translate(x, y, z) on a PMatrix2D.");
    }

    @Override
    public void rotate(float f) {
        float f2 = this.sin(f);
        float f3 = this.cos(f);
        float f4 = this.m00;
        float f5 = this.m01;
        this.m00 = f3 * f4 + f2 * f5;
        this.m01 = -f2 * f4 + f3 * f5;
        f4 = this.m10;
        f5 = this.m11;
        this.m10 = f3 * f4 + f2 * f5;
        this.m11 = -f2 * f4 + f3 * f5;
    }

    @Override
    public void rotateX(float f) {
        throw new IllegalArgumentException("Cannot use rotateX() on a PMatrix2D.");
    }

    @Override
    public void rotateY(float f) {
        throw new IllegalArgumentException("Cannot use rotateY() on a PMatrix2D.");
    }

    @Override
    public void rotateZ(float f) {
        this.rotate(f);
    }

    @Override
    public void rotate(float f, float f2, float f3, float f4) {
        throw new IllegalArgumentException("Cannot use this version of rotate() on a PMatrix2D.");
    }

    @Override
    public void scale(float f) {
        this.scale(f, f);
    }

    @Override
    public void scale(float f, float f2) {
        this.m00 *= f;
        this.m01 *= f2;
        this.m10 *= f;
        this.m11 *= f2;
    }

    @Override
    public void scale(float f, float f2, float f3) {
        throw new IllegalArgumentException("Cannot use this version of scale() on a PMatrix2D.");
    }

    @Override
    public void skewX(float f) {
        this.apply(1.0f, 0.0f, 1.0f, f, 0.0f, 0.0f);
    }

    @Override
    public void skewY(float f) {
        this.apply(1.0f, 0.0f, 1.0f, 0.0f, f, 0.0f);
    }

    @Override
    public void apply(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.apply((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.apply((PMatrix3D)pMatrix);
        }
    }

    @Override
    public void apply(PMatrix2D pMatrix2D) {
        this.apply(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    @Override
    public void apply(PMatrix3D pMatrix3D) {
        throw new IllegalArgumentException("Cannot use apply(PMatrix3D) on a PMatrix2D.");
    }

    @Override
    public void apply(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.m00;
        float f8 = this.m01;
        this.m00 = f * f7 + f4 * f8;
        this.m01 = f2 * f7 + f5 * f8;
        this.m02 += f3 * f7 + f6 * f8;
        f7 = this.m10;
        f8 = this.m11;
        this.m10 = f * f7 + f4 * f8;
        this.m11 = f2 * f7 + f5 * f8;
        this.m12 += f3 * f7 + f6 * f8;
    }

    @Override
    public void apply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        throw new IllegalArgumentException("Cannot use this version of apply() on a PMatrix2D.");
    }

    @Override
    public void preApply(PMatrix2D pMatrix2D) {
        this.preApply(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    @Override
    public void preApply(PMatrix3D pMatrix3D) {
        throw new IllegalArgumentException("Cannot use preApply(PMatrix3D) on a PMatrix2D.");
    }

    @Override
    public void preApply(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.m02;
        float f8 = this.m12;
        this.m02 = f3 += f7 * f + f8 * f2;
        this.m12 = f6 += f7 * f4 + f8 * f5;
        f7 = this.m00;
        f8 = this.m10;
        this.m00 = f7 * f + f8 * f2;
        this.m10 = f7 * f4 + f8 * f5;
        f7 = this.m01;
        f8 = this.m11;
        this.m01 = f7 * f + f8 * f2;
        this.m11 = f7 * f4 + f8 * f5;
    }

    @Override
    public void preApply(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        throw new IllegalArgumentException("Cannot use this version of preApply() on a PMatrix2D.");
    }

    @Override
    public PVector mult(PVector pVector, PVector pVector2) {
        if (pVector2 == null) {
            pVector2 = new PVector();
        }
        pVector2.x = this.m00 * pVector.x + this.m01 * pVector.y + this.m02;
        pVector2.y = this.m10 * pVector.x + this.m11 * pVector.y + this.m12;
        return pVector2;
    }

    @Override
    public float[] mult(float[] fArray, float[] fArray2) {
        if (fArray2 == null || fArray2.length != 2) {
            fArray2 = new float[2];
        }
        if (fArray == fArray2) {
            float f = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02;
            float f2 = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12;
            fArray2[0] = f;
            fArray2[1] = f2;
        } else {
            fArray2[0] = this.m00 * fArray[0] + this.m01 * fArray[1] + this.m02;
            fArray2[1] = this.m10 * fArray[0] + this.m11 * fArray[1] + this.m12;
        }
        return fArray2;
    }

    public float multX(float f, float f2) {
        return this.m00 * f + this.m01 * f2 + this.m02;
    }

    public float multY(float f, float f2) {
        return this.m10 * f + this.m11 * f2 + this.m12;
    }

    @Override
    public void transpose() {
    }

    @Override
    public boolean invert() {
        float f = this.determinant();
        if (Math.abs(f) <= Float.MIN_VALUE) {
            return false;
        }
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        this.m00 = f6 / f;
        this.m10 = -f5 / f;
        this.m01 = -f3 / f;
        this.m11 = f2 / f;
        this.m02 = (f3 * f7 - f6 * f4) / f;
        this.m12 = (f5 * f4 - f2 * f7) / f;
        return true;
    }

    @Override
    public float determinant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void print() {
        int n = (int)this.abs(this.max(PApplet.max(this.abs(this.m00), this.abs(this.m01), this.abs(this.m02)), PApplet.max(this.abs(this.m10), this.abs(this.m11), this.abs(this.m12))));
        int n2 = 1;
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            n2 = 5;
        } else {
            while ((n /= 10) != 0) {
                ++n2;
            }
        }
        System.out.println(PApplet.nfs(this.m00, n2, 4) + " " + PApplet.nfs(this.m01, n2, 4) + " " + PApplet.nfs(this.m02, n2, 4));
        System.out.println(PApplet.nfs(this.m10, n2, 4) + " " + PApplet.nfs(this.m11, n2, 4) + " " + PApplet.nfs(this.m12, n2, 4));
        System.out.println();
    }

    protected boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f;
    }

    protected boolean isWarped() {
        return this.m00 != 1.0f || this.m01 != 0.0f && this.m10 != 0.0f || this.m11 != 1.0f;
    }

    private final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    private final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    private final float sin(float f) {
        return (float)Math.sin(f);
    }

    private final float cos(float f) {
        return (float)Math.cos(f);
    }
}

