/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Controller;
import com.leapmotion.leap.Frame;
import com.leapmotion.leap.Gesture;
import com.leapmotion.leap.Listener;
import com.leapmotion.leap.Vector;
import de.voidplus.leapmotion.CircleGesture;
import de.voidplus.leapmotion.Device;
import de.voidplus.leapmotion.Finger;
import de.voidplus.leapmotion.Hand;
import de.voidplus.leapmotion.Image;
import de.voidplus.leapmotion.KeyTapGesture;
import de.voidplus.leapmotion.ScreenTapGesture;
import de.voidplus.leapmotion.SwipeGesture;
import de.voidplus.leapmotion.Tool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PVector;

public class LeapMotion {
    public static final String NAME = "Leap-Motion";
    public static final String REPO = "https://github.com/voidplus/leap-motion-processing";
    public static final String VERSION = "2.2.1.1";
    public static final String SDK_VERSION = "2.2.1+24116";
    private final PApplet parent;
    private PVector world;
    private PVector origin;
    private boolean verbose;
    private boolean withRecognition;
    private Frame frame;
    private Frame lastFrame;
    private ArrayList<Hand> hands;
    private ArrayList<Finger> fingers;
    private ArrayList<Finger> outstretchedFingers;
    private ArrayList<Finger> outstretchedFingersByAngel;
    private ArrayList<Tool> tools;
    private ArrayList<Device> devices;
    private ArrayList<Image> images;
    private final Controller controller;
    private final Listener listener;

    public LeapMotion(PApplet parent, boolean verbose) {
        this.parent = parent;
        this.log("# Leap-Motion-Library v2.2.1.1 - LeapMotion-SDK v2.2.1+24116 - https://github.com/voidplus/leap-motion-processing", true);
        this.setWorld(200, 500, 200);
        this.setVerbose(verbose);
        this.withRecognition = false;
        this.frame = Frame.invalid();
        this.lastFrame = Frame.invalid();
        this.hands = new ArrayList();
        this.fingers = new ArrayList();
        this.outstretchedFingers = new ArrayList();
        this.outstretchedFingersByAngel = new ArrayList();
        this.tools = new ArrayList();
        this.devices = new ArrayList();
        this.images = new ArrayList();
        this.controller = new Controller();
        this.listener = new Listener(){

            public void onInit(Controller controller) {
                LeapMotion.this.dispatch("leapOnInit");
            }

            public void onConnect(Controller controller) {
                LeapMotion.this.dispatch("leapOnConnect");
            }

            public void onDisconnect(Controller controller) {
                LeapMotion.this.dispatch("leapOnDisconnect");
            }

            public void onExit(Controller controller) {
                LeapMotion.this.dispatch("leapOnExit");
            }

            public void onFrame(Controller controller) {
                LeapMotion.this.frame = controller.frame();
                LeapMotion.this.dispatch("leapOnFrame");
            }
        };
        this.controller.addListener(this.listener);
        this.withBackgroundFrames();
        this.parent.registerDispose((Object)this);
    }

    public LeapMotion(PApplet parent) {
        this(parent, false);
    }

    public int getFrameRate() {
        if (this.isConnected()) {
            return (int)this.frame.currentFramesPerSecond();
        }
        return 0;
    }

    public long getTimestamp() {
        if (this.isConnected()) {
            return this.frame.timestamp();
        }
        return 0L;
    }

    public long getId() {
        if (this.isConnected()) {
            return this.frame.id();
        }
        return Frame.invalid().id();
    }

    public void printPolicyFlags() {
        Controller.PolicyFlag[] policyFlagArray = Controller.PolicyFlag.values();
        int n = policyFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            Controller.PolicyFlag flag = policyFlagArray[n2];
            if (this.controller.isPolicySet(flag)) {
                this.log("'" + flag.toString() + "' is set.");
            }
            ++n2;
        }
    }

    public LeapMotion withBackgroundFrames() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES);
        }
        return this;
    }

    public LeapMotion withoutBackgroundFrames() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_BACKGROUND_FRAMES);
        }
        return this;
    }

    public LeapMotion runInBackground(boolean active) {
        this.log("'runInBackground(" + Boolean.toString(active) + ")' is deprecated. Please use 'withBackgroundFrames()'.");
        return this.withBackgroundFrames();
    }

    public LeapMotion allowRunInBackground() {
        this.log("'allowRunInBackground()' is deprecated. Please use 'withBackgroundFrames()'.");
        return this.withBackgroundFrames();
    }

    public LeapMotion setWorld(int width, int height, int depth) {
        return this.setWorld(new PVector((float)width, (float)height, (float)depth));
    }

    public LeapMotion setWorld(PVector world) {
        this.world = world;
        return this;
    }

    public LeapMotion moveWorld(int x, int y, int z) {
        return this.moveWorld(new PVector((float)x, (float)y, (float)z));
    }

    public LeapMotion moveWorld(PVector origin) {
        this.origin = origin;
        return this;
    }

    public boolean isConnected() {
        return this.controller.isConnected();
    }

    public Controller getController() {
        return this.controller;
    }

    public ArrayList<Device> getDevices() {
        this.devices.clear();
        if (this.isConnected() && !this.getController().devices().isEmpty()) {
            for (com.leapmotion.leap.Device device : this.getController().devices()) {
                this.devices.add(new Device(this.parent, this, device));
            }
        }
        return this.devices;
    }

    public boolean hasHands() {
        if (this.isConnected()) {
            return !this.frame.hands().isEmpty();
        }
        return false;
    }

    public Hand getHand(Integer id) {
        com.leapmotion.leap.Hand hand = this.frame.hand(id.intValue());
        if (!LeapMotion.isNull(hand) && Hand.isValid(hand)) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public ArrayList<Hand> getHands() {
        this.hands.clear();
        if (this.hasHands()) {
            for (com.leapmotion.leap.Hand hand : this.frame.hands()) {
                if (!Hand.isValid(hand)) continue;
                this.hands.add(new Hand(this.parent, this, hand));
            }
        }
        return this.hands;
    }

    public int countHands() {
        if (this.isConnected()) {
            return this.frame.hands().count();
        }
        return 0;
    }

    public Hand getFrontHand() {
        com.leapmotion.leap.Hand hand;
        if (!this.frame.hands().isEmpty() && !LeapMotion.isNull(hand = this.frame.hands().frontmost()) && Hand.isValid(hand)) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public Hand getLeftHand() {
        com.leapmotion.leap.Hand hand;
        if (!this.frame.hands().isEmpty() && !LeapMotion.isNull(hand = this.frame.hands().leftmost()) && Hand.isValid(hand)) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public Hand getRightHand() {
        com.leapmotion.leap.Hand hand;
        if (!this.frame.hands().isEmpty() && !LeapMotion.isNull(hand = this.frame.hands().rightmost()) && Hand.isValid(hand)) {
            return new Hand(this.parent, this, hand);
        }
        return null;
    }

    public boolean hasFingers() {
        if (this.isConnected()) {
            return !this.frame.fingers().isEmpty();
        }
        return false;
    }

    public Finger getFinger(Integer id) {
        com.leapmotion.leap.Finger finger = this.frame.finger(id.intValue());
        if (!LeapMotion.isNull(finger) && Finger.isValid(finger)) {
            return new Finger(this.parent, this, finger);
        }
        return null;
    }

    public ArrayList<Finger> getFingers() {
        this.fingers.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers()) {
                if (!Finger.isValid(finger)) continue;
                this.fingers.add(new Finger(this.parent, this, finger));
            }
        }
        return this.fingers;
    }

    public ArrayList<Finger> getOutstrechtedFingers() {
        this.outstretchedFingers.clear();
        if (!this.frame.fingers().extended().isEmpty()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers().extended()) {
                this.outstretchedFingers.add(new Finger(this.parent, this, finger));
            }
        }
        return this.outstretchedFingers;
    }

    public ArrayList<Finger> getOutstrechtedFingers(int ignoreForBackwardsCompatibility) {
        return this.getOutstrechtedFingers();
    }

    public ArrayList<Finger> getOutstrechtedFingersByAngel(int similarity) {
        this.outstretchedFingersByAngel.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.frame.fingers()) {
                if (!Finger.isValid(finger)) continue;
                Finger candidate = new Finger(this.parent, this, finger);
                float distance = 0.0f;
                int b = 0;
                while (b < 4) {
                    distance += PVector.dist((PVector)candidate.getBone(b).getNextJoint(), (PVector)candidate.getBone(b).getPrevJoint());
                    ++b;
                }
                float direct = PVector.dist((PVector)candidate.getBone(0).getNextJoint(), (PVector)candidate.getBone(candidate.getType() != 0 ? 3 : 2).getPrevJoint());
                if (!(direct / distance * 100.0f >= (float)similarity)) continue;
                this.outstretchedFingersByAngel.add(candidate);
            }
        }
        return this.outstretchedFingersByAngel;
    }

    public ArrayList<Finger> getOutstrechtedFingersByAngel() {
        return this.getOutstrechtedFingersByAngel(75);
    }

    public int countFingers() {
        if (this.isConnected()) {
            return this.frame.fingers().count();
        }
        return 0;
    }

    public Finger getFrontFinger() {
        return new Finger(this.parent, this, this.frame.fingers().frontmost());
    }

    public Finger getLeftFinger() {
        return new Finger(this.parent, this, this.frame.fingers().leftmost());
    }

    public Finger getRightFinger() {
        return new Finger(this.parent, this, this.frame.fingers().rightmost());
    }

    public boolean hasTools() {
        if (this.isConnected()) {
            return !this.frame.tools().isEmpty();
        }
        return false;
    }

    public Tool getTool(Integer id) {
        com.leapmotion.leap.Tool tool = this.frame.tool(id.intValue());
        if (!LeapMotion.isNull(tool) && Tool.isValid(tool)) {
            return new Tool(this.parent, this, tool);
        }
        return null;
    }

    public ArrayList<Tool> getTools() {
        this.tools.clear();
        if (this.hasTools()) {
            for (com.leapmotion.leap.Tool tool : this.frame.tools()) {
                if (!Tool.isValid(tool)) continue;
                this.tools.add(new Tool(this.parent, this, tool));
            }
        }
        return this.tools;
    }

    public int countTools() {
        if (this.isConnected()) {
            return this.frame.tools().count();
        }
        return 0;
    }

    public Tool getFrontTool() {
        return new Tool(this.parent, this, this.frame.tools().frontmost());
    }

    public Tool getLeftTool() {
        return new Tool(this.parent, this, this.frame.tools().leftmost());
    }

    public Tool getRightTool() {
        return new Tool(this.parent, this, this.frame.tools().rightmost());
    }

    public LeapMotion withCameraImages() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_IMAGES);
        }
        return this;
    }

    public LeapMotion withoutCameraImages() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_IMAGES);
        }
        return this;
    }

    public boolean hasImages() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_IMAGES)) {
            if (this.controller.frame().images().count() > 0) {
                return true;
            }
        } else {
            this.withCameraImages();
        }
        return false;
    }

    public ArrayList<Image> getImages() {
        this.images.clear();
        if (this.hasImages()) {
            for (com.leapmotion.leap.Image image : this.controller.frame().images()) {
                if (!Image.isValid(image)) continue;
                this.images.add(new Image(this.parent, this, image));
            }
        }
        return this.images;
    }

    public LeapMotion withOptimizedHdm() {
        if (!this.controller.isPolicySet(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD)) {
            this.controller.setPolicy(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD);
        }
        return this;
    }

    public LeapMotion withoutOptimizedHdm() {
        if (this.controller.isPolicySet(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD)) {
            this.controller.clearPolicy(Controller.PolicyFlag.POLICY_OPTIMIZE_HMD);
        }
        return this;
    }

    public LeapMotion withGestures(String str) {
        str = str.trim().toUpperCase();
        List<String> gestures = Arrays.asList(str.split("\\s*,\\s*"));
        this.withRecognition = false;
        for (String gesture : gestures) {
            gesture = "TYPE_" + gesture;
            this.withRecognition = true;
            switch (Gesture.Type.valueOf((String)gesture)) {
                case TYPE_SWIPE: {
                    this.controller.enableGesture(Gesture.Type.TYPE_SWIPE);
                    break;
                }
                case TYPE_CIRCLE: {
                    this.controller.enableGesture(Gesture.Type.TYPE_CIRCLE);
                    break;
                }
                case TYPE_SCREEN_TAP: {
                    this.controller.enableGesture(Gesture.Type.TYPE_SCREEN_TAP);
                    break;
                }
                case TYPE_KEY_TAP: {
                    this.controller.enableGesture(Gesture.Type.TYPE_KEY_TAP);
                    break;
                }
                default: {
                    this.withRecognition = false;
                }
            }
        }
        if (this.withRecognition) {
            this.parent.registerPre((Object)this);
        } else {
            this.parent.unregisterPre((Object)this);
        }
        return this;
    }

    public LeapMotion withGestures() {
        return this.withGestures("swipe, circle, screen_tap, key_tap");
    }

    public LeapMotion withoutGestures() {
        this.parent.unregisterPre((Object)this);
        this.withRecognition = false;
        return this;
    }

    public void pre() {
        this.check();
    }

    private void check() {
        if (this.isConnected() && this.withRecognition) {
            block14: for (Gesture g : this.frame.gestures(this.lastFrame)) {
                if (!g.isValid()) continue;
                int state = 2;
                switch (g.type()) {
                    case TYPE_CIRCLE: {
                        if (g.state() == Gesture.State.STATE_START) {
                            state = 1;
                        } else if (g.state() == Gesture.State.STATE_STOP) {
                            state = 3;
                        }
                        try {
                            this.parent.getClass().getMethod("leapOnCircleGesture", CircleGesture.class, Integer.TYPE).invoke((Object)this.parent, new CircleGesture(this.parent, this, g), state);
                        }
                        catch (Exception exception) {}
                        continue block14;
                    }
                    case TYPE_SWIPE: {
                        if (g.state() == Gesture.State.STATE_START) {
                            state = 1;
                        } else if (g.state() == Gesture.State.STATE_STOP) {
                            state = 3;
                        }
                        try {
                            this.parent.getClass().getMethod("leapOnSwipeGesture", SwipeGesture.class, Integer.TYPE).invoke((Object)this.parent, new SwipeGesture(this.parent, this, g), state);
                        }
                        catch (Exception exception) {}
                        continue block14;
                    }
                    case TYPE_SCREEN_TAP: {
                        if (g.state() != Gesture.State.STATE_STOP) continue block14;
                        try {
                            this.parent.getClass().getMethod("leapOnScreenTapGesture", ScreenTapGesture.class).invoke((Object)this.parent, new ScreenTapGesture(this.parent, this, g));
                        }
                        catch (Exception exception) {}
                        continue block14;
                    }
                    case TYPE_KEY_TAP: {
                        if (g.state() != Gesture.State.STATE_STOP) continue block14;
                        try {
                            this.parent.getClass().getMethod("leapOnKeyTapGesture", KeyTapGesture.class).invoke((Object)this.parent, new KeyTapGesture(this.parent, this, g));
                        }
                        catch (Exception exception) {}
                        continue block14;
                    }
                    default: {
                        System.out.println("Unknown gesture type.");
                    }
                }
            }
            this.lastFrame = this.frame;
        }
    }

    public LeapMotion setGestureCircleMinRadius(float mm) {
        return this.setConfig("Gesture.Circle.MinRadius", mm);
    }

    public LeapMotion setGestureCircleMinArc(float degrees) {
        return this.setConfig("Gesture.Circle.MinArc", PApplet.radians((float)degrees));
    }

    public LeapMotion setGestureSwipeMinLength(float mm) {
        return this.setConfig("Gesture.Swipe.MinLength", mm);
    }

    public LeapMotion setGestureSwipeMinVelocity(float mms) {
        return this.setConfig("Gesture.Swipe.MinVelocity", mms);
    }

    public LeapMotion setGestureKeyTapMinDownVelocity(float mms) {
        return this.setConfig("Gesture.KeyTap.MinDownVelocity", mms);
    }

    public LeapMotion setGestureKeyTapHistorySeconds(float s) {
        return this.setConfig("Gesture.KeyTap.HistorySeconds", s);
    }

    public LeapMotion setGestureKeyTapMinDistance(float mm) {
        return this.setConfig("Gesture.KeyTap.MinDistance", mm);
    }

    public LeapMotion setGestureScreenTapMinForwardVelocity(float mms) {
        return this.setConfig("Gesture.ScreenTap.MinForwardVelocity", mms);
    }

    public LeapMotion setGestureScreenTapHistorySeconds(float s) {
        return this.setConfig("Gesture.ScreenTap.HistorySeconds", s);
    }

    public LeapMotion setGestureScreenTapMinDistance(float mm) {
        return this.setConfig("Gesture.ScreenTap.MinDistance", mm);
    }

    public LeapMotion setConfig(String keyString, int value) {
        if (this.controller.isConnected() && this.controller.config().setInt32(keyString, value)) {
            this.controller.config().save();
        }
        this.controller.config().save();
        return this;
    }

    public LeapMotion setConfig(String keyString, float value) {
        if (this.controller.isConnected() && this.controller.config().setFloat(keyString, value)) {
            this.controller.config().save();
        }
        return this;
    }

    public LeapMotion setConfig(String keyString, boolean value) {
        if (this.controller.isConnected() && this.controller.config().setBool(keyString, value)) {
            this.controller.config().save();
        }
        return this;
    }

    public LeapMotion setConfig(String keyString, String value) {
        if (this.controller.isConnected() && this.controller.config().setString(keyString, value)) {
            this.controller.config().save();
        }
        return this;
    }

    protected PVector map(Vector position) {
        PVector response = new PVector();
        response.x = position.getX() > 0.0f ? PApplet.lerp((float)((float)this.parent.width * 0.5f), (float)this.parent.width, (float)(position.getX() / this.world.x)) : PApplet.lerp((float)((float)this.parent.width * 0.5f), (float)0.0f, (float)(-position.getX() / this.world.x));
        response.y = PApplet.lerp((float)this.parent.height, (float)0.0f, (float)(position.getY() / this.world.y));
        response.z = PApplet.lerp((float)50.0f, (float)0.0f, (float)(position.getZ() / this.world.z));
        return this.move(response);
    }

    protected PVector convert(Vector position) {
        return this.move(new PVector(position.getX(), position.getY(), position.getZ()));
    }

    private PVector move(PVector position) {
        if (this.origin != null) {
            position.x += this.origin.x;
            position.y += this.origin.y;
            position.z += this.origin.z;
        }
        return position;
    }

    private void dispatch(String method) {
        boolean success = false;
        try {
            try {
                this.parent.getClass().getMethod(method, new Class[0]).invoke((Object)this.parent, new Object[0]);
                success = true;
            }
            catch (Exception exception) {
                if (success && this.verbose) {
                    this.log("Callback " + method + "();");
                }
            }
        }
        finally {
            if (success && this.verbose) {
                this.log("Callback " + method + "();");
            }
        }
    }

    public LeapMotion setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getVersionSDK() {
        return SDK_VERSION;
    }

    public void dispose() {
        this.controller.removeListener(this.listener);
    }

    private void log(String message, boolean skip) {
        if (!skip) {
            PApplet.println((String)("# Leap-Motion: " + message));
        } else {
            PApplet.println((String)message);
        }
    }

    private void log(String message) {
        this.log(message, false);
    }

    private static boolean isNull(Object object) {
        return object == null;
    }
}

