/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.SerialPortList;

public class Serial
implements SerialPortEventListener {
    private SerialPort port;
    private CharsetDecoder bytesToStrings;
    private static final int IN_BUFFER_CAPACITY = 128;
    private static final int OUT_BUFFER_CAPACITY = 128;
    private ByteBuffer inFromSerial = ByteBuffer.allocate(128);
    private CharBuffer outToMessage = CharBuffer.allocate(128);

    public Serial() throws SerialException {
        this(PreferencesData.get("serial.port"), PreferencesData.getInteger("serial.debug_rate", 9600), PreferencesData.getNonEmpty("serial.parity", "N").charAt(0), PreferencesData.getInteger("serial.databits", 8), PreferencesData.getFloat("serial.stopbits", 1.0f));
    }

    public Serial(int irate) throws SerialException {
        this(PreferencesData.get("serial.port"), irate, PreferencesData.getNonEmpty("serial.parity", "N").charAt(0), PreferencesData.getInteger("serial.databits", 8), PreferencesData.getFloat("serial.stopbits", 1.0f));
    }

    public Serial(String iname, int irate) throws SerialException {
        this(iname, irate, PreferencesData.getNonEmpty("serial.parity", "N").charAt(0), PreferencesData.getInteger("serial.databits", 8), PreferencesData.getFloat("serial.stopbits", 1.0f));
    }

    public Serial(String iname) throws SerialException {
        this(iname, PreferencesData.getInteger("serial.debug_rate", 9600), PreferencesData.getNonEmpty("serial.parity", "N").charAt(0), PreferencesData.getInteger("serial.databits", 8), PreferencesData.getFloat("serial.stopbits", 1.0f));
    }

    public static boolean touchForCDCReset(String iname) throws SerialException {
        SerialPort serialPort = new SerialPort(iname);
        try {
            serialPort.openPort();
            serialPort.setParams(1200, 8, 1, 0);
            serialPort.setDTR(false);
            serialPort.closePort();
            boolean bl = true;
            return bl;
        }
        catch (SerialPortException e) {
            throw new SerialException(I18n.format(I18n.tr("Error touching serial port ''{0}''."), iname), e);
        }
        finally {
            if (serialPort.isOpened()) {
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException serialPortException) {}
            }
        }
    }

    private Serial(String iname, int irate, char iparity, int idatabits, float istopbits) throws SerialException {
        this.resetDecoding(StandardCharsets.UTF_8);
        int parity = 0;
        if (iparity == 'E') {
            parity = 2;
        }
        if (iparity == 'O') {
            parity = 1;
        }
        int stopbits = 1;
        if (istopbits == 1.5f) {
            stopbits = 3;
        }
        if (istopbits == 2.0f) {
            stopbits = 2;
        }
        try {
            this.port = new SerialPort(iname);
            this.port.openPort();
            boolean res = this.port.setParams(irate, idatabits, stopbits, parity, true, true);
            if (!res) {
                System.err.println(I18n.format(I18n.tr("Error while setting serial port parameters: {0} {1} {2} {3}"), irate, Character.valueOf(iparity), idatabits, Float.valueOf(istopbits)));
            }
            this.port.addEventListener((SerialPortEventListener)this);
        }
        catch (SerialPortException e) {
            if (e.getPortName().startsWith("/dev") && "Permission denied".equals(e.getExceptionType())) {
                throw new SerialException(I18n.format(I18n.tr("Error opening serial port ''{0}''. Try consulting the documentation at http://playground.arduino.cc/Linux/All#Permission"), iname));
            }
            throw new SerialException(I18n.format(I18n.tr("Error opening serial port ''{0}''."), iname), e);
        }
        if (this.port == null) {
            throw new SerialNotFoundException(I18n.format(I18n.tr("Serial port ''{0}'' not found. Did you select the right one from the Tools > Serial Port menu?"), iname));
        }
    }

    public void setup() {
    }

    public void dispose() throws IOException {
        if (this.port != null) {
            try {
                if (this.port.isOpened()) {
                    this.port.closePort();
                }
            }
            catch (SerialPortException e) {
                throw new IOException(e);
            }
            finally {
                this.port = null;
            }
        }
    }

    public synchronized void serialEvent(SerialPortEvent serialEvent) {
        if (serialEvent.isRXCHAR()) {
            try {
                byte[] buf = this.port.readBytes(serialEvent.getEventValue());
                int next = 0;
                while (next < buf.length) {
                    while (next < buf.length && this.outToMessage.hasRemaining()) {
                        int spaceInIn = this.inFromSerial.remaining();
                        int copyNow = buf.length - next < spaceInIn ? buf.length - next : spaceInIn;
                        this.inFromSerial.put(buf, next, copyNow);
                        next += copyNow;
                        this.inFromSerial.flip();
                        this.bytesToStrings.decode(this.inFromSerial, this.outToMessage, false);
                        this.inFromSerial.compact();
                    }
                    this.outToMessage.flip();
                    if (this.outToMessage.hasRemaining()) {
                        char[] chars = new char[this.outToMessage.remaining()];
                        this.outToMessage.get(chars);
                        this.message(chars, chars.length);
                    }
                    this.outToMessage.clear();
                }
            }
            catch (SerialPortException e) {
                Serial.errorMessage("serialEvent", e);
            }
        }
    }

    protected void message(char[] chars, int length) {
    }

    public void write(int what) {
        try {
            this.port.writeInt(what & 0xFF);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(byte[] bytes) {
        try {
            this.port.writeBytes(bytes);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(String what) {
        this.write(what.getBytes());
    }

    public void setDTR(boolean state) {
        try {
            this.port.setDTR(state);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("setDTR", e);
        }
    }

    public void setRTS(boolean state) {
        try {
            this.port.setRTS(state);
        }
        catch (SerialPortException e) {
            Serial.errorMessage("setRTS", e);
        }
    }

    public synchronized void resetDecoding(Charset charset) {
        this.bytesToStrings = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("\u2e2e");
    }

    public static List<String> list() {
        return Arrays.asList(SerialPortList.getPortNames());
    }

    private static void errorMessage(String where, Throwable e) {
        System.err.println(I18n.format(I18n.tr("Error inside Serial.{0}()"), where));
        e.printStackTrace();
    }
}

