/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.network.BoardReachabilityFilter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import javax.jmdns.JmmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import processing.app.BaseNoGui;

public class NetworkDiscovery
implements Discovery,
ServiceListener {
    private final List<BoardPort> reachableBoardPorts = new LinkedList<BoardPort>();
    private final List<BoardPort> boardPortsDiscoveredWithJmDNS = new LinkedList<BoardPort>();
    private Timer reachabilityTimer;
    private JmmDNS jmdns = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDuplicateBoards(BoardPort newBoard) {
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            Iterator<BoardPort> iterator = this.boardPortsDiscoveredWithJmDNS.iterator();
            while (iterator.hasNext()) {
                BoardPort board = iterator.next();
                if (!newBoard.getAddress().equals(board.getAddress())) continue;
                iterator.remove();
            }
        }
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceEvent serviceEvent) {
        String name = serviceEvent.getName();
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            this.boardPortsDiscoveredWithJmDNS.stream().filter(port -> port.getBoardName().equals(name)).forEach(this.boardPortsDiscoveredWithJmDNS::remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(ServiceEvent serviceEvent) {
        while (BaseNoGui.packages == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ServiceInfo info = serviceEvent.getInfo();
        for (Inet4Address inetAddress : info.getInet4Addresses()) {
            String address = ((InetAddress)inetAddress).getHostAddress();
            String name = serviceEvent.getName();
            BoardPort port = new BoardPort();
            String board = null;
            String description = null;
            if (info.hasData()) {
                board = info.getPropertyString("board");
                description = info.getPropertyString("description");
                port.getPrefs().put("board", board);
                port.getPrefs().put("distro_version", info.getPropertyString("distro_version"));
                port.getPrefs().put("port", "" + info.getPort());
                String useSSH = info.getPropertyString("ssh_upload");
                String checkTCP = info.getPropertyString("tcp_check");
                String useAuth = info.getPropertyString("auth_upload");
                if (useSSH == null || !useSSH.contentEquals("no")) {
                    useSSH = "yes";
                }
                if (checkTCP == null || !checkTCP.contentEquals("no")) {
                    checkTCP = "yes";
                }
                if (useAuth == null || !useAuth.contentEquals("yes")) {
                    useAuth = "no";
                }
                port.getPrefs().put("ssh_upload", useSSH);
                port.getPrefs().put("tcp_check", checkTCP);
                port.getPrefs().put("auth_upload", useAuth);
            }
            String label = name + " at " + address;
            if (board != null && BaseNoGui.packages != null) {
                String boardName = BaseNoGui.getPlatform().resolveDeviceByBoardID(BaseNoGui.packages, board);
                if (boardName != null) {
                    label = label + " (" + boardName + ")";
                }
            } else if (description != null) {
                label = label + " (" + description + ")";
            }
            port.setAddress(address);
            port.setBoardName(name);
            port.setProtocol("network");
            port.setLabel(label);
            List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
            synchronized (list) {
                this.removeDuplicateBoards(port);
                this.boardPortsDiscoveredWithJmDNS.add(port);
            }
        }
    }

    @Override
    public void start() {
        this.jmdns = JmmDNS.Factory.getInstance();
        this.jmdns.addServiceListener("_arduino._tcp.local.", (ServiceListener)this);
        this.reachabilityTimer = new Timer();
        new BoardReachabilityFilter(this).start(this.reachabilityTimer);
    }

    @Override
    public void stop() {
        this.jmdns.unregisterAllServices();
        this.reachabilityTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoardPort> listDiscoveredBoards() {
        List<BoardPort> list = this.reachableBoardPorts;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.reachableBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoardPort> listDiscoveredBoards(boolean complete) {
        List<BoardPort> list = this.reachableBoardPorts;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.reachableBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReachableBoardPorts(List<BoardPort> newReachableBoardPorts) {
        List<BoardPort> list = this.reachableBoardPorts;
        synchronized (list) {
            this.reachableBoardPorts.clear();
            this.reachableBoardPorts.addAll(newReachableBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BoardPort> getBoardPortsDiscoveredWithJmDNS() {
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.boardPortsDiscoveredWithJmDNS);
        }
    }
}

