/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.legacy.PApplet;

public abstract class AbstractMonitor
extends JFrame
implements ActionListener {
    private boolean closed;
    private StringBuffer updateBuffer;
    private Timer updateTimer;
    private BoardPort boardPort;
    protected String[] serialRateStrings = new String[]{"300", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "74880", "115200", "230400", "250000", "500000", "1000000", "2000000"};

    public AbstractMonitor(BoardPort boardPort) {
        super(boardPort.getLabel());
        this.boardPort = boardPort;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                try {
                    AbstractMonitor.this.closed = true;
                    AbstractMonitor.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        KeyStroke wc = Editor.WINDOW_CLOSE_KEYSTROKE;
        this.getRootPane().getInputMap(1).put(wc, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    AbstractMonitor.this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AbstractMonitor.this.setVisible(false);
            }
        });
        this.onCreateWindow(this.getContentPane());
        this.setMinimumSize(new Dimension(this.getContentPane().getMinimumSize().width, this.getPreferredSize().height));
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (PreferencesData.get((String)"last.screen.height") != null) {
            String locationStr;
            int screenW = PreferencesData.getInteger((String)"last.screen.width");
            int screenH = PreferencesData.getInteger((String)"last.screen.height");
            if (screen.width == screenW && screen.height == screenH && (locationStr = PreferencesData.get((String)"last.serial.location")) != null) {
                int[] location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
                this.setPlacement(location);
            }
        }
        this.updateBuffer = new StringBuffer(0x100000);
        this.updateTimer = new Timer(33, this);
        this.updateTimer.start();
        this.closed = false;
    }

    protected abstract void onCreateWindow(Container var1);

    public void enableWindow(boolean enable) {
        this.onEnableWindow(enable);
    }

    protected abstract void onEnableWindow(boolean var1);

    public void suspend() throws Exception {
        this.enableWindow(false);
        this.close();
    }

    public void resume(BoardPort boardPort) throws Exception {
        this.setBoardPort(boardPort);
        this.enableWindow(true);
        if (!this.isVisible()) {
            return;
        }
        this.open();
    }

    protected void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
    }

    protected int[] getPlacement() {
        int[] location = new int[4];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        return location;
    }

    public abstract void message(String var1);

    public boolean requiresAuthorization() {
        return false;
    }

    public String getAuthorizationKey() {
        return null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void open() throws Exception {
        this.closed = false;
    }

    public void close() throws Exception {
        this.closed = true;
    }

    public BoardPort getBoardPort() {
        return this.boardPort;
    }

    public void setBoardPort(BoardPort boardPort) {
        if (boardPort == null) {
            return;
        }
        this.setTitle(boardPort.getLabel());
        this.boardPort = boardPort;
    }

    public synchronized void addToUpdateBuffer(char[] buff, int n) {
        this.updateBuffer.append(buff, 0, n);
    }

    private synchronized String consumeUpdateBuffer() {
        String s = this.updateBuffer.toString();
        this.updateBuffer.setLength(0);
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = this.consumeUpdateBuffer();
        if (s.isEmpty()) {
            return;
        }
        this.message(s);
    }
}

