/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.findreplace;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorTab;
import processing.app.I18n;
import processing.app.helpers.OSUtils;

public class FindReplace
extends JFrame {
    private static final String FIND_TEXT = "findText";
    private static final String REPLACE_TEXT = "replaceText";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String SEARCH_ALL_FILES = "searchAllFiles";
    private static final String WRAP_AROUND = "wrapAround";
    private final Editor editor;
    private JPanel buttonsContainer;
    private JButton findButton;
    private JTextField findField;
    private JCheckBox ignoreCaseBox;
    private JButton previousButton;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JTextField replaceField;
    private JButton replaceFindButton;
    private JCheckBox searchAllFilesBox;
    private JCheckBox wrapAroundBox;

    public FindReplace(Editor editor, Map<String, Object> state) {
        this.editor = editor;
        this.initComponents();
        if (OSUtils.isMacOS()) {
            this.buttonsContainer.removeAll();
            this.buttonsContainer.add(this.replaceAllButton);
            this.buttonsContainer.add(this.replaceButton);
            this.buttonsContainer.add(this.replaceFindButton);
            this.buttonsContainer.add(this.previousButton);
            this.buttonsContainer.add(this.findButton);
        }
        Base.registerWindowCloseKeys(this.getRootPane(), e -> {
            this.setVisible(false);
            Base.FIND_DIALOG_STATE = this.findDialogState();
        });
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
        this.restoreFindDialogState(state);
    }

    @Override
    public void setVisible(boolean b) {
        this.getRootPane().setDefaultButton(this.findButton);
        super.setVisible(b);
    }

    private Map<String, Object> findDialogState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(FIND_TEXT, this.findField.getText());
        state.put(REPLACE_TEXT, this.replaceField.getText());
        state.put(IGNORE_CASE, this.ignoreCaseBox.isSelected());
        state.put(WRAP_AROUND, this.wrapAroundBox.isSelected());
        state.put(SEARCH_ALL_FILES, this.searchAllFilesBox.isSelected());
        return state;
    }

    private void restoreFindDialogState(Map<String, Object> state) {
        if (state.containsKey(FIND_TEXT)) {
            this.findField.setText((String)state.get(FIND_TEXT));
        }
        if (state.containsKey(REPLACE_TEXT)) {
            this.replaceField.setText((String)state.get(REPLACE_TEXT));
        }
        if (state.containsKey(IGNORE_CASE)) {
            this.ignoreCaseBox.setSelected((Boolean)state.get(IGNORE_CASE));
        }
        if (state.containsKey(SEARCH_ALL_FILES)) {
            this.searchAllFilesBox.setSelected((Boolean)state.get(SEARCH_ALL_FILES));
        }
        if (state.containsKey(WRAP_AROUND)) {
            this.wrapAroundBox.setSelected((Boolean)state.get(WRAP_AROUND));
        }
    }

    private void initComponents() {
        JLabel findLabel = new JLabel();
        this.findField = new JTextField();
        JLabel replaceLabel = new JLabel();
        this.replaceField = new JTextField();
        this.ignoreCaseBox = new JCheckBox();
        this.wrapAroundBox = new JCheckBox();
        this.searchAllFilesBox = new JCheckBox();
        this.buttonsContainer = new JPanel();
        this.findButton = new JButton();
        this.previousButton = new JButton();
        this.replaceFindButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAllButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n.tr((String)"Find"));
        this.setResizable(false);
        findLabel.setText(I18n.tr((String)"Find:"));
        this.findField.setColumns(20);
        replaceLabel.setText(I18n.tr((String)"Replace with:"));
        this.replaceField.setColumns(20);
        this.ignoreCaseBox.setSelected(true);
        this.ignoreCaseBox.setText(I18n.tr((String)"Ignore Case"));
        this.wrapAroundBox.setSelected(true);
        this.wrapAroundBox.setText(I18n.tr((String)"Wrap Around"));
        this.searchAllFilesBox.setText(I18n.tr((String)"Search all Sketch Tabs"));
        this.findButton.setText(I18n.tr((String)"Find"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.findButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.findButton);
        this.previousButton.setText(I18n.tr((String)"Previous"));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.previousButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.previousButton);
        this.replaceFindButton.setText(I18n.tr((String)"Replace & Find"));
        this.replaceFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceFindButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceFindButton);
        this.replaceButton.setText(I18n.tr((String)"Replace"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceButton);
        this.replaceAllButton.setText(I18n.tr((String)"Replace All"));
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceAllButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceAllButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(replaceLabel).addComponent(findLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findField).addComponent(this.replaceField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchAllFilesBox).addComponent(this.wrapAroundBox).addComponent(this.ignoreCaseBox)).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.buttonsContainer, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(findLabel).addComponent(this.findField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(replaceLabel).addComponent(this.replaceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreCaseBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapAroundBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchAllFilesBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsContainer, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.findNext();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.findPrevious();
    }

    private void replaceFindButtonActionPerformed(ActionEvent evt) {
        this.replaceAndFindNext();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.replace();
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        this.replaceAll();
    }

    private boolean find(boolean wrap, boolean backwards, boolean searchTabs, int originTab) {
        int nextIndex;
        String search = this.findField.getText();
        if (search.length() == 0) {
            return false;
        }
        String text = this.editor.getCurrentTab().getText();
        if (this.ignoreCaseBox.isSelected()) {
            search = search.toLowerCase();
            text = text.toLowerCase();
        }
        if (!backwards) {
            int selectionEnd = this.editor.getCurrentTab().getSelectionStop();
            nextIndex = text.indexOf(search, selectionEnd);
        } else {
            int selectionStart = this.editor.getCurrentTab().getSelectionStart() - 1;
            nextIndex = selectionStart >= 0 ? text.lastIndexOf(search, selectionStart) : -1;
        }
        if (nextIndex == -1) {
            int realCurrentTab;
            int numTabs;
            if (searchTabs && (numTabs = this.editor.getTabs().size()) > 1 && originTab != (realCurrentTab = this.editor.getCurrentTabIndex())) {
                if (originTab < 0) {
                    originTab = realCurrentTab;
                }
                if (!wrap && (!backwards && realCurrentTab + 1 >= numTabs || backwards && realCurrentTab - 1 < 0)) {
                    return false;
                }
                if (backwards) {
                    this.editor.selectPrevTab();
                    this.setVisible(true);
                    int l = this.editor.getCurrentTab().getText().length() - 1;
                    this.editor.getCurrentTab().setSelection(l, l);
                } else {
                    this.editor.selectNextTab();
                    this.setVisible(true);
                    this.editor.getCurrentTab().setSelection(0, 0);
                }
                return this.find(wrap, backwards, true, originTab);
            }
            if (wrap) {
                int n = nextIndex = backwards ? text.lastIndexOf(search) : text.indexOf(search, 0);
            }
        }
        if (nextIndex != -1) {
            EditorTab currentTab = this.editor.getCurrentTab();
            currentTab.getTextArea().getFoldManager().ensureOffsetNotInClosedFold(nextIndex);
            currentTab.setSelection(nextIndex, nextIndex + search.length());
            currentTab.getTextArea().getCaret().setSelectionVisible(true);
            return true;
        }
        return false;
    }

    private void replace() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        int newpos = this.editor.getCurrentTab().getSelectionStart() - this.findField.getText().length();
        if (newpos < 0) {
            newpos = 0;
        }
        this.editor.getCurrentTab().setSelection(newpos, newpos);
        boolean foundAtLeastOne = false;
        if (this.find(false, false, this.searchAllFilesBox.isSelected(), -1)) {
            foundAtLeastOne = true;
            this.editor.getCurrentTab().setSelectedText(this.replaceField.getText());
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    private void replaceAll() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        if (this.searchAllFilesBox.isSelected()) {
            this.editor.selectTab(0);
        }
        this.editor.getCurrentTab().setSelection(0, 0);
        boolean foundAtLeastOne = false;
        while (this.find(false, false, this.searchAllFilesBox.isSelected(), -1)) {
            foundAtLeastOne = true;
            this.editor.getCurrentTab().setSelectedText(this.replaceField.getText());
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findNext() {
        if (!this.find(this.wrapAroundBox.isSelected(), false, this.searchAllFilesBox.isSelected(), -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findPrevious() {
        if (!this.find(this.wrapAroundBox.isSelected(), true, this.searchAllFilesBox.isSelected(), -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setFindText(String text) {
        if (text == null) {
            return;
        }
        this.findField.setText(text);
    }
}

