/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.NoopProgressListener;
import cc.arduino.contributions.ProgressListener;
import cc.arduino.contributions.libraries.LibraryInstaller;
import cc.arduino.contributions.libraries.filters.UpdatableLibraryPredicate;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.filters.UpdatablePlatformPredicate;
import cc.arduino.view.NotificationPopup;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;

public class ContributionsSelfCheck
extends TimerTask {
    private final Base base;
    private final HyperlinkListener hyperlinkListener;
    private final ContributionInstaller contributionInstaller;
    private final LibraryInstaller libraryInstaller;
    private final ProgressListener progressListener;
    private volatile boolean cancelled;
    private volatile NotificationPopup notificationPopup;

    public ContributionsSelfCheck(Base base, HyperlinkListener hyperlinkListener, ContributionInstaller contributionInstaller, LibraryInstaller libraryInstaller) {
        this.base = base;
        this.hyperlinkListener = hyperlinkListener;
        this.contributionInstaller = contributionInstaller;
        this.libraryInstaller = libraryInstaller;
        this.progressListener = new NoopProgressListener();
        this.cancelled = false;
    }

    @Override
    public void run() {
        this.updateContributionIndex();
        this.updateLibrariesIndex();
        long updatablePlatforms = BaseNoGui.indexer.getPackages().stream().flatMap(pack -> pack.getPlatforms().stream()).filter(new UpdatablePlatformPredicate()).count();
        long updatableLibraries = BaseNoGui.librariesIndexer.getInstalledLibraries().stream().filter(new UpdatableLibraryPredicate()).count();
        if (updatableLibraries <= 0L && updatablePlatforms <= 0L) {
            return;
        }
        String text = updatableLibraries > 0L && updatablePlatforms <= 0L ? I18n.format((String)I18n.tr((String)"Updates available for some of your {0}libraries{1}"), (Object[])new Object[]{"<a href=\"http://librarymanager/DropdownUpdatableLibrariesItem\">", "</a>"}) : (updatableLibraries <= 0L && updatablePlatforms > 0L ? I18n.format((String)I18n.tr((String)"Updates available for some of your {0}boards{1}"), (Object[])new Object[]{"<a href=\"http://boardsmanager/DropdownUpdatableCoresItem\">", "</a>"}) : I18n.format((String)I18n.tr((String)"Updates available for some of your {0}boards{1} and {2}libraries{3}"), (Object[])new Object[]{"<a href=\"http://boardsmanager/DropdownUpdatableCoresItem\">", "</a>", "<a href=\"http://librarymanager/DropdownUpdatableLibrariesItem\">", "</a>"}));
        if (this.cancelled) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Editor ed = this.base.getActiveEditor();
            this.notificationPopup = new NotificationPopup((Frame)ed, this.hyperlinkListener, text);
            if (ed.isFocused()) {
                this.notificationPopup.begin();
                return;
            }
            WindowFocusListener wfl = new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent evt) {
                }

                @Override
                public void windowGainedFocus(WindowEvent evt) {
                    ContributionsSelfCheck.this.notificationPopup.begin();
                    for (Editor e : ContributionsSelfCheck.this.base.getEditors()) {
                        e.removeWindowFocusListener(this);
                    }
                }
            };
            for (Editor e : this.base.getEditors()) {
                e.addWindowFocusListener(wfl);
            }
        });
    }

    @Override
    public boolean cancel() {
        this.cancelled = true;
        if (this.notificationPopup != null) {
            this.notificationPopup.close();
        }
        return super.cancel();
    }

    private void updateLibrariesIndex() {
        if (this.cancelled) {
            return;
        }
        try {
            this.libraryInstaller.updateIndex(this.progressListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateContributionIndex() {
        if (this.cancelled) {
            return;
        }
        try {
            this.contributionInstaller.updateIndex(this.progressListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

