/*
 * Decompiled with CFR 0.152.
 */
package development;

import de.voidplus.leapmotion.CircleGesture;
import de.voidplus.leapmotion.Finger;
import de.voidplus.leapmotion.Hand;
import de.voidplus.leapmotion.Image;
import de.voidplus.leapmotion.KeyTapGesture;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.ScreenTapGesture;
import de.voidplus.leapmotion.SwipeGesture;
import de.voidplus.leapmotion.Tool;
import processing.core.PApplet;
import processing.core.PVector;

public class Sketch
extends PApplet {
    LeapMotion leap;

    public void setup() {
        this.size(1200, 800, "processing.opengl.PGraphics3D");
        this.background(250);
        this.leap = new LeapMotion(this);
        this.leap.withCameraImages();
    }

    public void draw() {
        this.background(250);
        if (this.leap.hasImages()) {
            for (Image camera : this.leap.getImages()) {
                if (camera.isLeft()) {
                    this.image(camera, 0.0f, 0.0f);
                    continue;
                }
                this.image(camera, 0.0f, camera.getHeight());
            }
        }
        for (Hand hand : this.leap.getHands()) {
            float touch_distance;
            int touch_zone;
            int hand_id = hand.getId();
            PVector hand_position = hand.getPosition();
            PVector hand_stabilized = hand.getStabilizedPosition();
            PVector hand_direction = hand.getDirection();
            PVector hand_dynamics = hand.getDynamics();
            float hand_roll = hand.getRoll();
            float hand_pitch = hand.getPitch();
            float hand_yaw = hand.getYaw();
            boolean hand_is_left = hand.isLeft();
            boolean hand_is_right = hand.isRight();
            float hand_grab = hand.getGrabStrength();
            float hand_pinch = hand.getPinchStrength();
            PVector sphere_position = hand.getSpherePosition();
            float sphere_radius = hand.getSphereRadius();
            Finger finger_thumb = hand.getThumb();
            Finger finger_index = hand.getIndexFinger();
            Finger finger_middle = hand.getMiddleFinger();
            Finger finger_ring = hand.getRingFinger();
            Finger finger_pink = hand.getPinkyFinger();
            for (Finger finger : hand.getFingers()) {
                int finger_id = finger.getId();
                PVector finger_position = finger.getPosition();
                PVector finger_velocity = finger.getVelocity();
                PVector finger_direction = finger.getDirection();
                touch_zone = finger.getTouchZone();
                touch_distance = finger.getTouchDistance();
                switch (touch_zone) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
            for (Tool tool : hand.getTools()) {
                int tool_id = tool.getId();
                PVector tool_position = tool.getPosition();
                PVector tool_velocity = tool.getVelocity();
                PVector tool_direction = tool.getDirection();
                touch_zone = tool.getTouchZone();
                touch_distance = tool.getTouchDistance();
                switch (touch_zone) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
                tool.draw();
            }
        }
        for (Finger finger : this.leap.getOutstrechtedFingers()) {
            finger.draw();
        }
    }

    public void leapOnInit() {
    }

    public void leapOnConnect() {
    }

    public void leapOnFrame() {
    }

    public void leapOnDisconnect() {
    }

    public void leapOnExit() {
    }

    public void leapOnSwipeGesture(SwipeGesture g, int state) {
        int id = g.getId();
        Finger finger = g.getFinger();
        PVector position = g.getPosition();
        PVector position_start = g.getStartPosition();
        PVector direction = g.getDirection();
        float speed = g.getSpeed();
        long duration = g.getDuration();
        float duration_seconds = g.getDurationInSeconds();
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Sketch.println((String)("SwipeGesture: " + id));
            }
        }
    }

    public void leapOnCircleGesture(CircleGesture g, int state) {
        int id = g.getId();
        Finger finger = g.getFinger();
        PVector position_center = g.getCenter();
        float radius = g.getRadius();
        float progress = g.getProgress();
        long duration = g.getDuration();
        float duration_seconds = g.getDurationInSeconds();
        switch (state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Sketch.println((String)("CircleGesture: " + id));
            }
        }
    }

    public void leapOnScreenTapGesture(ScreenTapGesture g) {
        int id = g.getId();
        Finger finger = g.getFinger();
        PVector position = g.getPosition();
        PVector direction = g.getDirection();
        long duration = g.getDuration();
        float duration_seconds = g.getDurationInSeconds();
        Sketch.println((String)("ScreenTapGesture: " + id));
    }

    public void leapOnKeyTapGesture(KeyTapGesture g) {
        int id = g.getId();
        Finger finger = g.getFinger();
        PVector position = g.getPosition();
        PVector direction = g.getDirection();
        long duration = g.getDuration();
        float duration_seconds = g.getDurationInSeconds();
        Sketch.println((String)("KeyTapGesture: " + id));
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"development.Sketch"});
    }
}

