/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.LeapMotion;
import processing.core.PApplet;
import processing.core.PVector;

public class Pointable {
    protected PApplet parent;
    protected com.leapmotion.leap.Pointable pointable;
    protected LeapMotion leap;

    public Pointable(PApplet parent, LeapMotion leap, com.leapmotion.leap.Pointable pointable) {
        this.parent = parent;
        this.leap = leap;
        this.pointable = pointable;
    }

    public int getId() {
        return this.pointable.id();
    }

    public PVector getPosition() {
        return this.leap.map(this.pointable.tipPosition());
    }

    public PVector getRawPosition() {
        return this.leap.convert(this.pointable.tipPosition());
    }

    public PVector getStabilizedPosition() {
        return this.leap.map(this.pointable.stabilizedTipPosition());
    }

    public PVector getRawStabilizedPosition() {
        return this.leap.convert(this.pointable.tipPosition());
    }

    public PVector getVelocity() {
        return this.leap.map(this.pointable.tipVelocity());
    }

    public PVector getRawVelocity() {
        return this.leap.convert(this.pointable.tipVelocity());
    }

    public PVector getDirection() {
        return new PVector(this.pointable.direction().getX(), -this.pointable.direction().getY(), this.pointable.direction().getZ());
    }

    public float getTouchDistance() {
        return this.pointable.touchDistance();
    }

    public int getTouchZone() {
        switch (this.pointable.touchZone()) {
            case ZONE_NONE: {
                return -1;
            }
            case ZONE_HOVERING: {
                return 0;
            }
            case ZONE_TOUCHING: {
                return 1;
            }
        }
        return -1;
    }

    public float getLength() {
        return this.pointable.length();
    }

    public float getTimeVisible() {
        return this.pointable.timeVisible();
    }

    public boolean isValid() {
        return this.pointable.isValid();
    }

    protected boolean isFinger() {
        return this.pointable.isFinger();
    }

    protected boolean isTool() {
        return this.pointable.isTool();
    }
}

