/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Bone;
import com.leapmotion.leap.Finger;
import de.voidplus.leapmotion.Bone;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.Pointable;
import processing.core.PApplet;
import processing.core.PVector;

public class Finger
extends Pointable {
    private com.leapmotion.leap.Finger finger;
    private Finger.Joint Joint;

    public Finger(PApplet parent, LeapMotion leap, com.leapmotion.leap.Finger finger) {
        super(parent, leap, (com.leapmotion.leap.Pointable)finger);
        this.finger = finger;
    }

    @Override
    public boolean isValid() {
        return this.finger.isValid();
    }

    protected static boolean isValid(com.leapmotion.leap.Finger finger) {
        return finger.isValid();
    }

    public PVector getPositionOfJointTip() {
        return this.leap.map(this.finger.jointPosition(Finger.Joint.JOINT_TIP));
    }

    public PVector getPositionOfJointMcp() {
        return this.leap.map(this.finger.jointPosition(Finger.Joint.JOINT_MCP));
    }

    public PVector getPositionOfJointPip() {
        return this.leap.map(this.finger.jointPosition(Finger.Joint.JOINT_PIP));
    }

    public PVector getPositionOfJointDip() {
        return this.leap.map(this.finger.jointPosition(Finger.Joint.JOINT_DIP));
    }

    public PVector getRawPositionOfJointTip() {
        return this.leap.convert(this.finger.jointPosition(Finger.Joint.JOINT_TIP));
    }

    public PVector getRawPositionOfJointMcp() {
        return this.leap.convert(this.finger.jointPosition(Finger.Joint.JOINT_MCP));
    }

    public PVector getRawPositionOfJointPip() {
        return this.leap.convert(this.finger.jointPosition(Finger.Joint.JOINT_PIP));
    }

    public PVector getRawPositionOfJointDip() {
        return this.leap.convert(this.finger.jointPosition(Finger.Joint.JOINT_DIP));
    }

    public int getType() {
        Finger.Type type = this.finger.type();
        switch (type) {
            case TYPE_THUMB: {
                return 0;
            }
            case TYPE_INDEX: {
                return 1;
            }
            case TYPE_MIDDLE: {
                return 2;
            }
            case TYPE_RING: {
                return 3;
            }
            case TYPE_PINKY: {
                return 4;
            }
        }
        return -1;
    }

    public Bone getBone(String name) {
        if ((name = name.toLowerCase()).equals("distal")) {
            return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_DISTAL));
        }
        if (name.equals("intermediate")) {
            return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_INTERMEDIATE));
        }
        if (name.equals("proximal")) {
            return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_PROXIMAL));
        }
        if (name.equals("metacarpal")) {
            return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_METACARPAL));
        }
        return null;
    }

    public Bone getBone(int type) {
        switch (type) {
            case 0: {
                return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_DISTAL));
            }
            case 1: {
                return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_INTERMEDIATE));
            }
            case 2: {
                return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_PROXIMAL));
            }
            case 3: {
                return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_METACARPAL));
            }
        }
        return null;
    }

    public Bone getDistalBone() {
        return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_DISTAL));
    }

    public Bone getIntermediateBone() {
        return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_INTERMEDIATE));
    }

    public Bone getMetacarpalBone() {
        return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_METACARPAL));
    }

    public Bone getProximalBone() {
        return new Bone(this.parent, this.leap, this.finger.bone(Bone.Type.TYPE_PROXIMAL));
    }

    public void drawLines(boolean pre) {
        if (pre) {
            this.parent.stroke(0);
            this.parent.noFill();
        }
        PVector tip = this.getPositionOfJointTip();
        PVector mcp = this.getPositionOfJointMcp();
        PVector pip = this.getPositionOfJointPip();
        PVector dip = this.getPositionOfJointDip();
        this.parent.beginShape();
        if (this.parent.g.is2D()) {
            this.parent.vertex(mcp.x, mcp.y);
            this.parent.vertex(pip.x, pip.y);
            this.parent.vertex(dip.x, dip.y);
            this.parent.vertex(tip.x, tip.y);
        } else {
            this.parent.vertex(mcp.x, mcp.y, mcp.z);
            this.parent.vertex(pip.x, pip.y, pip.z);
            this.parent.vertex(dip.x, dip.y, dip.z);
            this.parent.vertex(tip.x, tip.y, tip.z);
        }
        this.parent.endShape(1);
    }

    public void drawLines() {
        this.drawLines(true);
    }

    public void drawBones(boolean pre) {
        this.getBone(0).draw(pre);
        this.getBone(1).draw(pre);
        this.getBone(2).draw(pre);
        if (this.getType() != 0) {
            this.getBone(3).draw(pre);
        }
    }

    public void drawBones() {
        this.drawBones(true);
    }

    public void drawJoints(float radius, boolean pre) {
        if (pre) {
            this.parent.noStroke();
            this.parent.fill(0);
        }
        PVector tip = this.getPositionOfJointTip();
        PVector mcp = this.getPositionOfJointMcp();
        PVector pip = this.getPositionOfJointPip();
        PVector dip = this.getPositionOfJointDip();
        if (this.parent.g.is2D()) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(tip.x, tip.y, radius, radius);
            this.parent.ellipse(mcp.x, mcp.y, radius, radius);
            this.parent.ellipse(pip.x, pip.y, radius, radius);
            this.parent.ellipse(dip.x, dip.y, radius, radius);
        } else {
            this.parent.sphereDetail(20);
            this.parent.pushMatrix();
            this.parent.translate(tip.x, tip.y, tip.z);
            this.parent.sphere(radius);
            this.parent.popMatrix();
            this.parent.pushMatrix();
            this.parent.translate(mcp.x, mcp.y, mcp.z);
            this.parent.sphere(radius);
            this.parent.popMatrix();
            this.parent.pushMatrix();
            this.parent.translate(pip.x, pip.y, pip.z);
            this.parent.sphere(radius);
            this.parent.popMatrix();
            this.parent.pushMatrix();
            this.parent.translate(dip.x, dip.y, dip.z);
            this.parent.sphere(radius);
            this.parent.popMatrix();
        }
    }

    public void drawJoints(int radius) {
        this.drawJoints(radius, true);
    }

    public void drawJoints(boolean pre) {
        this.drawJoints(3.0f, pre);
    }

    public void drawJoints() {
        this.drawJoints(3.0f, true);
    }

    public void draw(float radius, boolean pre) {
        this.drawBones(pre);
        this.drawJoints(radius, pre);
    }

    public void draw(int radius) {
        this.draw(radius, true);
    }

    public void draw(boolean pre) {
        this.draw(3.0f, pre);
    }

    public void draw() {
        this.draw(3.0f, true);
    }
}

