/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import com.leapmotion.leap.Bone;
import de.voidplus.leapmotion.LeapMotion;
import processing.core.PApplet;
import processing.core.PVector;

public class Bone {
    protected PApplet parent;
    protected com.leapmotion.leap.Bone bone;
    protected LeapMotion leap;

    public Bone(PApplet parent, LeapMotion leap, com.leapmotion.leap.Bone bone) {
        this.parent = parent;
        this.leap = leap;
        this.bone = bone;
    }

    public boolean isValid() {
        return this.bone.isValid();
    }

    protected static boolean isValid(com.leapmotion.leap.Bone bone) {
        return bone.isValid();
    }

    public int getType() {
        Bone.Type type = this.bone.type();
        switch (type) {
            case TYPE_DISTAL: {
                return 0;
            }
            case TYPE_INTERMEDIATE: {
                return 1;
            }
            case TYPE_PROXIMAL: {
                return 2;
            }
            case TYPE_METACARPAL: {
                return 3;
            }
        }
        return -1;
    }

    public float getBoneLength() {
        return this.bone.length();
    }

    public float getBoneWidth() {
        return this.bone.width();
    }

    public PVector getNextJoint() {
        return this.leap.map(this.bone.nextJoint());
    }

    public PVector getRawNextJoint() {
        return this.leap.convert(this.bone.nextJoint());
    }

    public PVector getPrevJoint() {
        return this.leap.map(this.bone.prevJoint());
    }

    public PVector getRawPrevJoint() {
        return this.leap.convert(this.bone.prevJoint());
    }

    public PVector getDirection() {
        return this.leap.map(this.bone.direction());
    }

    public PVector getRawDirection() {
        return this.leap.convert(this.bone.direction());
    }

    public void draw(boolean pre) {
        if (pre) {
            this.parent.stroke(0, 35.0f);
            this.parent.noFill();
        }
        PVector next = this.getNextJoint();
        PVector prev = this.getPrevJoint();
        this.parent.beginShape(5);
        if (this.parent.g.is2D()) {
            this.parent.vertex(next.x, next.y);
            this.parent.vertex(prev.x, prev.y);
        } else {
            this.parent.vertex(next.x, next.y, next.z);
            this.parent.vertex(prev.x, prev.y, prev.z);
        }
        this.parent.endShape(1);
    }

    public void draw() {
        this.draw(true);
    }
}

