/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.util;

import com.ardublock.util.SafeHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesReader {
    public static Map<String, PropertiesReader> propertiesReaderMap = new SafeHashMap<String, PropertiesReader>();
    public static final String DEFAULT_PROPERTIES_FILE = "heqichen.properties";
    private String filename;
    private Properties p;

    private PropertiesReader(String filename) {
        this.filename = filename;
        InputStream is = PropertiesReader.class.getClassLoader().getResourceAsStream(this.filename);
        if (is == null) {
            System.out.println("no file found: " + this.filename);
        }
        this.p = new Properties();
        try {
            this.p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getValue(String key) {
        return PropertiesReader.getValue(key, DEFAULT_PROPERTIES_FILE);
    }

    public static String getValue(String key, String file) {
        PropertiesReader propertiesReader = PropertiesReader.getPropertiesReader(file);
        return propertiesReader.readValue(key);
    }

    private String readValue(String key) {
        return this.p.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PropertiesReader getPropertiesReader(String filename) {
        PropertiesReader propertiesReader = propertiesReaderMap.get(filename);
        if (propertiesReader != null) return propertiesReader;
        Class<PropertiesReader> clazz = PropertiesReader.class;
        synchronized (PropertiesReader.class) {
            propertiesReader = propertiesReaderMap.get(filename);
            if (propertiesReader != null) return propertiesReader;
            propertiesReader = new PropertiesReader(filename);
            propertiesReaderMap.put(filename, propertiesReader);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return propertiesReader;
        }
    }
}

