/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class DigitalInputPulldownBlock
extends TranslatorBlock {
    public static final String ARDUBLOCK_DIGITAL_READ_PULLDOWN_DEFINE = "boolean __ardublockDigitalReadPULLDOWN(int pinNumber)\n{\npinMode(pinNumber, INPUT_PULLUP);\nreturn !digitalRead(pinNumber);\n}\n\n";

    public DigitalInputPulldownBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        if (translatorBlock instanceof NumberBlock) {
            return this.generateCodeUsingNumberBlock(translatorBlock);
        }
        return this.generateCodeUsingNonNumberBlock(translatorBlock);
    }

    protected String generateCodeUsingNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        String number = translatorBlock.toCode();
        this.translator.addInputPin(number.trim());
        String ret = "!digitalRead(";
        ret = ret + number;
        ret = ret + ")";
        return this.codePrefix + ret + this.codeSuffix;
    }

    protected String generateCodeUsingNonNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addDefinitionCommand(ARDUBLOCK_DIGITAL_READ_PULLDOWN_DEFINE);
        String ret = "__ardublockDigitalReadPULLDOWN(";
        ret = ret + translatorBlock.toCode();
        ret = ret + ")";
        return this.codePrefix + ret + this.codeSuffix;
    }
}

