/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock;

import com.ardublock.core.Context;
import com.ardublock.ui.ArduBlockToolFrame;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.app.Editor;
import processing.app.tools.Tool;

public class ArduBlockToolMini
implements Tool,
OpenblocksFrameListener {
    static Editor editor;
    static ArduBlockToolFrame openblocksFrame;

    public void init(Editor editor) {
        if (ArduBlockToolMini.editor == null) {
            ArduBlockToolMini.editor = editor;
            openblocksFrame = new ArduBlockToolFrame();
            openblocksFrame.addListener(this);
            Context context = Context.getContext();
            String arduinoVersion = this.getArduinoVersion();
            context.setInArduino(true);
            context.setArduinoVersionString(arduinoVersion);
            context.setEditor(editor);
            System.out.println("Arduino Version: " + arduinoVersion);
        }
    }

    public void run() {
        try {
            editor.toFront();
            openblocksFrame.setVisible(true);
            openblocksFrame.toFront();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMenuTitle() {
        return "ArduBlock Mini";
    }

    public void didSave() {
    }

    public void didLoad() {
    }

    public void didSaveAs() {
    }

    public void didNew() {
    }

    public void didGenerate(String source) {
        try {
            Class<?> ed = editor.getClass();
            Class[] cArg = new Class[]{String.class};
            Method method = ed.getMethod("setText", cArg);
            method.invoke((Object)editor, source);
        }
        catch (NoSuchMethodException e) {
            editor.getCurrentTab().setText(source);
        }
        catch (IllegalAccessException e) {
            editor.getCurrentTab().setText(source);
        }
        catch (SecurityException e) {
            editor.getCurrentTab().setText(source);
        }
        catch (InvocationTargetException e) {
            editor.getCurrentTab().setText(source);
        }
        editor.handleExport(false);
    }

    private String getArduinoVersion() {
        Context context = Context.getContext();
        File versionFile = context.getArduinoFile("lib/version.txt");
        if (versionFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(versionFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                String line = reader.readLine();
                reader.close();
                if (line == null) {
                    return "unknown";
                }
                if ((line = line.trim()).length() == 0) {
                    return "unknown";
                }
                return line;
            }
            catch (FileNotFoundException e) {
                return "unknown";
            }
            catch (UnsupportedEncodingException e) {
                return "unknown";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "unknown";
            }
        }
        return "unknown";
    }
}

