/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.Arm;
import de.voidplus.leapmotion.Finger;
import de.voidplus.leapmotion.LeapMotion;
import de.voidplus.leapmotion.Tool;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;

public class Hand
implements PConstants {
    private PApplet parent;
    private com.leapmotion.leap.Hand hand;
    private LeapMotion leap;
    private ArrayList<Finger> fingers;
    private ArrayList<Finger> outstretchedFingers;
    private ArrayList<Finger> outstretchedFingersByAngel;
    private ArrayList<Tool> tools;

    public Hand(PApplet parent, LeapMotion leap, com.leapmotion.leap.Hand hand) {
        this.parent = parent;
        this.leap = leap;
        this.hand = hand;
        this.fingers = new ArrayList();
        this.outstretchedFingers = new ArrayList();
        this.outstretchedFingersByAngel = new ArrayList();
        this.tools = new ArrayList();
    }

    public boolean isValid() {
        return this.hand.isValid();
    }

    protected static boolean isValid(com.leapmotion.leap.Hand hand) {
        return hand.isValid();
    }

    public int getId() {
        return this.hand.id();
    }

    public PVector getPosition() {
        return this.leap.map(this.hand.palmPosition());
    }

    public PVector getRawPosition() {
        return this.leap.convert(this.hand.palmPosition());
    }

    public PVector getPalmPosition() {
        return this.getPosition();
    }

    public PVector getStabilizedPosition() {
        return this.leap.map(this.hand.stabilizedPalmPosition());
    }

    public PVector getStabilizedPalmPosition() {
        return this.getStabilizedPosition();
    }

    public PVector getRawStabilizedPosition() {
        return this.leap.convert(this.hand.stabilizedPalmPosition());
    }

    public PVector getRawStabilizedParlmPosition() {
        return this.getRawStabilizedPosition();
    }

    public PVector getDirection() {
        return this.leap.map(this.hand.direction());
    }

    public PVector getRawDirection() {
        return this.leap.convert(this.hand.direction());
    }

    public float getConfidence() {
        return this.hand.confidence();
    }

    public boolean isLeft() {
        return this.hand.isLeft();
    }

    public boolean isRight() {
        return this.hand.isRight();
    }

    public float getGrabStrength() {
        return this.hand.grabStrength();
    }

    public float getPinchStrength() {
        return this.hand.pinchStrength();
    }

    public float getTimeVisible() {
        return this.hand.timeVisible();
    }

    public Finger getFrontFinger() {
        return new Finger(this.parent, this.leap, this.hand.fingers().frontmost());
    }

    public Finger getLeftFinger() {
        return new Finger(this.parent, this.leap, this.hand.fingers().leftmost());
    }

    public Finger getRightFinger() {
        return new Finger(this.parent, this.leap, this.hand.fingers().rightmost());
    }

    public Tool getFrontTool() {
        return new Tool(this.parent, this.leap, this.hand.tools().frontmost());
    }

    public Tool getLeftTool() {
        return new Tool(this.parent, this.leap, this.hand.tools().leftmost());
    }

    public Tool getRightTool() {
        return new Tool(this.parent, this.leap, this.hand.tools().rightmost());
    }

    public PVector getDynamics() {
        return new PVector(this.getRoll(), this.getPitch(), this.getYaw());
    }

    public float getRoll() {
        return PApplet.degrees((float)this.hand.direction().pitch());
    }

    public float getPitch() {
        return -PApplet.degrees((float)this.hand.palmNormal().roll());
    }

    public float getYaw() {
        return PApplet.degrees((float)this.hand.direction().yaw());
    }

    public PVector getSpherePosition() {
        return this.leap.map(this.hand.sphereCenter());
    }

    public PVector getRawSpherePosition() {
        return this.leap.convert(this.hand.sphereCenter());
    }

    public float getSphereRadius() {
        return this.hand.sphereRadius();
    }

    public ArrayList<Finger> getFingers() {
        this.fingers.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.hand.fingers()) {
                this.fingers.add(new Finger(this.parent, this.leap, finger));
            }
        }
        return this.fingers;
    }

    public ArrayList<Finger> getOutstrechtedFingers() {
        this.outstretchedFingers.clear();
        if (!this.hand.fingers().extended().isEmpty()) {
            for (com.leapmotion.leap.Finger finger : this.hand.fingers().extended()) {
                this.outstretchedFingers.add(new Finger(this.parent, this.leap, finger));
            }
        }
        return this.outstretchedFingers;
    }

    public ArrayList<Finger> getOutstrechtedFingers(int ignoreForBackwardsCompatibility) {
        return this.getOutstrechtedFingers();
    }

    public ArrayList<Finger> getOutstrechtedFingersByAngel(int similarity) {
        this.outstretchedFingersByAngel.clear();
        if (this.hasFingers()) {
            for (com.leapmotion.leap.Finger finger : this.hand.fingers()) {
                if (!Finger.isValid(finger)) continue;
                Finger candidate = new Finger(this.parent, this.leap, finger);
                float distance = 0.0f;
                int b = 0;
                while (b < 4) {
                    distance += PVector.dist((PVector)candidate.getBone(b).getNextJoint(), (PVector)candidate.getBone(b).getPrevJoint());
                    ++b;
                }
                float direct = PVector.dist((PVector)candidate.getBone(0).getNextJoint(), (PVector)candidate.getBone(candidate.getType() != 0 ? 3 : 2).getPrevJoint());
                if (!(direct / distance * 100.0f >= (float)similarity)) continue;
                this.outstretchedFingersByAngel.add(candidate);
            }
        }
        return this.outstretchedFingersByAngel;
    }

    public ArrayList<Finger> getOutstrechtedFingersByAngel() {
        return this.getOutstrechtedFingersByAngel(75);
    }

    public ArrayList<Finger> getRawOutstrechtedFingers() {
        this.outstretchedFingers.clear();
        return this.outstretchedFingers;
    }

    public boolean hasFingers() {
        if (this.leap.isConnected()) {
            return !this.hand.fingers().isEmpty();
        }
        return false;
    }

    public int countFingers() {
        if (this.leap.isConnected()) {
            return this.hand.fingers().count();
        }
        return 0;
    }

    public Finger getFinger(int type) {
        for (Finger finger : this.getFingers()) {
            if (finger.getType() != type) continue;
            return finger;
        }
        return null;
    }

    public Finger getFinger(String name) {
        if ((name = name.toLowerCase()).equals("thumb")) {
            return this.getFinger(0);
        }
        if (name.equals("index")) {
            return this.getFinger(1);
        }
        if (name.equals("middle")) {
            return this.getFinger(2);
        }
        if (name.equals("ring")) {
            return this.getFinger(3);
        }
        if (name.equals("pinky")) {
            return this.getFinger(4);
        }
        return null;
    }

    public Finger getThumb() {
        return this.getFinger(0);
    }

    public Finger getIndexFinger() {
        return this.getFinger(1);
    }

    public Finger getMiddleFinger() {
        return this.getFinger(2);
    }

    public Finger getRingFinger() {
        return this.getFinger(3);
    }

    public Finger getPinkyFinger() {
        return this.getFinger(4);
    }

    public ArrayList<Tool> getTools() {
        this.tools.clear();
        if (this.hasTools()) {
            for (com.leapmotion.leap.Tool tool : this.hand.tools()) {
                this.tools.add(new Tool(this.parent, this.leap, tool));
            }
        }
        return this.tools;
    }

    public boolean hasTools() {
        if (this.leap.isConnected()) {
            return !this.hand.tools().isEmpty();
        }
        return false;
    }

    public int countTools() {
        if (this.leap.isConnected()) {
            return this.hand.tools().count();
        }
        return 0;
    }

    public Arm getArm() {
        return new Arm(this.parent, this.leap, this.hand.arm());
    }

    public boolean hasArm() {
        return this.hand.arm().isValid();
    }

    public void draw(float radius, boolean pre) {
        if (pre) {
            this.parent.noStroke();
            this.parent.fill(0);
        }
        PVector position = this.getPosition();
        if (this.parent.g.is2D()) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(position.x, position.y, radius, radius);
        } else {
            this.parent.pushMatrix();
            this.parent.translate(position.x, position.y, position.z);
            this.parent.sphereDetail(20);
            this.parent.sphere(radius);
            this.parent.popMatrix();
        }
        if (this.hasFingers()) {
            for (Finger finger : this.getFingers()) {
                finger.draw(pre);
            }
        }
    }

    public void draw(int radius) {
        this.draw(radius, true);
    }

    public void draw(boolean pre) {
        this.draw(5.0f, pre);
    }

    public void draw() {
        this.draw(5.0f, true);
    }

    public void drawFingers(int radius, boolean pre) {
        if (this.hasFingers()) {
            for (Finger finger : this.fingers) {
                finger.draw(radius, pre);
            }
        }
    }

    public void drawFingers(int radius) {
        this.drawFingers(radius, true);
    }

    public void drawFingers(boolean pre) {
        this.drawFingers(3, pre);
    }

    public void drawFingers() {
        this.drawFingers(3, true);
    }

    public void drawSphere(boolean pre) {
        if (pre) {
            this.parent.stroke(0, 10.0f);
            this.parent.noFill();
        }
        PVector position = this.getSpherePosition();
        float radius = this.getSphereRadius();
        if (this.parent.g.is2D()) {
            this.parent.ellipseMode(3);
            this.parent.ellipse(position.x, position.y, radius, radius);
        } else {
            this.parent.pushMatrix();
            this.parent.translate(position.x, position.y, position.z);
            this.parent.sphereDetail(12);
            this.parent.sphere(radius);
            this.parent.popMatrix();
        }
    }

    public void drawSphere() {
        this.drawSphere(true);
    }
}

