/* Copyright (c) 2014, Nordic Semiconductor ASA
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Attention! 
*  To maintain compliance with Nordic Semiconductor ASA's Bluetooth profile 
*  qualification listings, this section of source code must not be modified.
*/

#ifndef ALERT_LEVEL_CHARACTERISTIC_H
#define ALERT_LEVEL_CHARACTERISTIC_H

/** @file
 * @brief 
 */
 
/** @defgroup alert_level_characteristic alert_level_characteristic
* @{
* @ingroup services
*  
* @brief alert_level_characteristic : defines possibles alert levels.
* 
*/

/** Possible Alert Levels*/
typedef enum alert_level_t
{
  /** No alert*/                           
  ALERT_LEVEL_NO_ALERT   = 0,
  /** Mild/moderate alert*/                           
  ALERT_LEVEL_MILD_ALERT = 1,
  /** high alert*/                           
  ALERT_LEVEL_HIGH_ALERT = 2,
}alert_level_t;

/** @} */

#endif // ALERT_LEVEL_CHARACTERISTIC_H
