/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.DigitalInputBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class InversedDigitalInputBlock
extends DigitalInputBlock {
    public InversedDigitalInputBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    protected String generateCodeUsingNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        String number = translatorBlock.toCode();
        this.translator.addInputPin(number.trim());
        String ret = "!digitalRead(";
        ret = String.valueOf(ret) + number;
        ret = String.valueOf(ret) + ")";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }

    protected String generateCodeUsingNonNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addDefinitionCommand("boolean __ardublockDigitalRead(int pinNumber)\n{\npinMode(pinNumber, INPUT);\nreturn digitalRead(pinNumber);\n}\n\n");
        String ret = "!__ardublockDigitalRead(";
        ret = String.valueOf(ret) + translatorBlock.toCode();
        ret = String.valueOf(ret) + ")";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

