/*
	Librairie créée par David Souder - 08/07/2014
	Librairie inspirée par le programme Seeed Grove disponible ici :
	http://www.seeedstudio.com/wiki/Grove_-_125KHz_RFID_Reader
	Cette librairie est librement utilisable
	www.duinoedu.com

*/

// Voir infos en bas de page


#ifndef GUINO_H
#define GUINO_H

//#include <SoftwareSerial.h>
#include <EasyTransfer.h>
#include <EEPROM.h>
#include "EDU_debug.h"
#include <EasyTransfer.h>
#include <EEPROM.h>

//----- Nécessaire si utilisation de String
	#if defined(ARDUINO) && ARDUINO >= 100
	#include "Arduino.h"
	#else
	#include <WProgram.h>
	#include "Wire.h"
	#endif

//----- Langage EDU
#define faire void
#define initialisation setup()
#define boucle loop()
#define portSerie Serial.begin(9600)
#define lectureEtat digitalRead
#define utiliser 
#define chaine String
#define nombre int
#define grandNombre long
#define si if
#define sinon else


//----- Includes propres à Guino
#define guino_executed -1
#define guino_init 0
#define guino_addSlider 1
#define guino_addButton 2
#define guino_iamhere 3
#define guino_addToggle 4
#define guino_addRotarySlider 5
#define guino_saveToBoard 6
#define guino_setFixedGraphBuffer 8
#define guino_clearLabel 7
#define guino_addWaveform 9
#define guino_addColumn 10
#define guino_addSpacer 11
#define guino_addMovingGraph 13
#define guino_buttonPressed 14
#define guino_addChar 15
#define guino_setMin 16
#define guino_setMax 17
#define guino_setValue 20
#define guino_addLabel 12
#define guino_large 0
#define guino_medium 1
#define guino_small 2
#define guino_setColor  21

struct SEND_DATA_STRUCTURE{
  //put your variable definitions here for the data you want to send
  //THIS MUST BE EXACTLY THE SAME ON THE OTHER ARDUINO
  char cmd;
  char item;
  int value;
};

//----- Début classe
class Guino {

public:

		/*EDU US*/	Guino();

	//---- Initialisation
		void gInit();
		void gButtonPressed(int id);

		
	//---- Fonctions opératives
		void EEPROMWriteInt(int p_address, int p_value);
		unsigned int EEPROMReadInt(int p_address);
		void update();
		void gInitEEprom();
		void gSetColor(int _red, int _green, int _blue);
		void gGetSavedValue(int item_number, int *_variable);
		void gBegin(int _eepromKey);
		int gAddButton(char * _name);
		void gAddColumn();
		int gAddLabel(char * _name, int _size);
		int gAddSpacer(int _size);
		int gAddToggle(char * _name, int * _variable);
		int gAddFixedGraph(char * _name,int _min,int _max,int _bufferSize, int * _variable, int _size);
		int gAddMovingGraph(char * _name,int _min,int _max, int * _variable, int _size);
		int gUpdateLabel(int _item, char * _text);
		int gAddRotarySlider(int _min,int _max, char * _name, int * _variable);
		int gAddSlider(int _min,int _max, char * _name, int * _variable);
		void gUpdateValue(int _item);
		void gUpdateValue(int * _variable);
		void gSendCommand(byte _cmd, byte _item, int _value);

		
		
	//---- Modification options

		
		
	//---- Variables publiques
			
	//---- Propriétés 

		

private:
		
	//---- Méthodes

	

	//---- Objets internes
		//give a name to the group of data
		SEND_DATA_STRUCTURE guino_data;
		EasyTransfer ET; 
	
	//---- Propriétés EDU
	
	//---- Propriéts Guino
		boolean guidino_initialized;
		int eepromKey;
		int guino_maxGUIItems;
		int guino_item_counter;
		int *guino_item_values[100]; 
		int gTmpInt; // temporary int for items without a variable
		boolean internalInit; // boolean to initialize before connecting to serial
		int test;
		
	//---- Gestion de la mémoire 


};


#endif

