/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;

public class TextBlockPanel
extends JPanel {
    private static final Dimension PREFERRED_SIZE = new Dimension(500, 300);
    private String text;
    private Font font;

    public TextBlockPanel(String text, Font font) {
        this.text = text;
        this.font = font;
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        double x = ((RectangularShape)available).getX();
        double y = ((RectangularShape)available).getY();
        float width = (float)((RectangularShape)available).getWidth();
        TextBlock block = TextUtilities.createTextBlock(this.text, this.font, Color.black, width, new G2TextMeasurer(g2));
        g2.setPaint(Color.black);
        block.draw(g2, (float)x, (float)y, TextBlockAnchor.TOP_LEFT, 0.0f, 0.0f, 0.0);
    }
}

